/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.IntegralGenerator;
import com.pholser.junit.quickcheck.internal.Comparables;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public class ShortGenerator
extends IntegralGenerator<Short> {
    private short min = (Short)Reflection.defaultValueOf(InRange.class, (String)"minShort");
    private short max = (Short)Reflection.defaultValueOf(InRange.class, (String)"maxShort");

    public ShortGenerator() {
        super(Arrays.asList(Short.class, Short.TYPE));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minShort() : Short.parseShort(range.min());
        this.max = range.max().isEmpty() ? range.maxShort() : Short.parseShort(range.max());
    }

    public Short generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextShort(this.min, this.max);
    }

    @Override
    protected Function<BigInteger, Short> narrow() {
        return Number::shortValue;
    }

    @Override
    protected Predicate<Short> inRange() {
        return Comparables.inRange((Comparable)Short.valueOf(this.min), (Comparable)Short.valueOf(this.max));
    }

    @Override
    protected Short leastMagnitude() {
        return (Short)Comparables.leastMagnitude((Comparable)Short.valueOf(this.min), (Comparable)Short.valueOf(this.max), (Comparable)Short.valueOf((short)0));
    }

    @Override
    protected boolean negative(Short target) {
        return target < 0;
    }

    @Override
    protected Short negate(Short target) {
        return -target.shortValue();
    }

    public BigDecimal magnitude(Object value) {
        return BigDecimal.valueOf(((Short)this.narrow(value)).shortValue());
    }
}

