/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;

public class ClockGenerator
extends Generator<Clock> {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private Instant min = Instant.MIN;
    private Instant max = Instant.MAX;

    public ClockGenerator() {
        super(Clock.class);
    }

    public void configure(InRange range) {
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = Instant.parse(range.min());
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = Instant.parse(range.max());
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    public Clock generate(SourceOfRandomness random, GenerationStatus status) {
        return Clock.fixed(random.nextInstant(this.min, this.max), UTC_ZONE_ID);
    }
}

