/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeGenerator
extends Generator<LocalDateTime> {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private LocalDateTime min = LocalDateTime.MIN;
    private LocalDateTime max = LocalDateTime.MAX;

    public LocalDateTimeGenerator() {
        super(LocalDateTime.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = LocalDateTime.parse(range.min(), formatter);
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = LocalDateTime.parse(range.max(), formatter);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    public LocalDateTime generate(SourceOfRandomness random, GenerationStatus status) {
        return LocalDateTime.ofInstant(random.nextInstant(this.min.atZone(UTC_ZONE_ID).toInstant(), this.max.atZone(UTC_ZONE_ID).toInstant()), UTC_ZONE_ID);
    }
}

