/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.impl;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinAnalogOutput;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioPinOutput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.GpioPinShutdown;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.impl.GpioEventMonitorExecutorImpl;
import com.pi4j.io.gpio.impl.GpioPinShutdownImpl;
import com.pi4j.io.gpio.impl.GpioScheduledExecutorImpl;
import com.pi4j.io.gpio.trigger.GpioTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class GpioPinImpl
implements GpioPin,
GpioPinDigitalInput,
GpioPinDigitalOutput,
GpioPinAnalogInput,
GpioPinAnalogOutput,
GpioPinPwmOutput,
GpioPinInput,
GpioPinOutput {
    private final GpioController gpio;
    private String name = null;
    private Object tag = null;
    private final GpioProvider provider;
    private final Pin pin;
    private PinListener monitor;
    private final GpioPinShutdownImpl shutdownOptions;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private final List<GpioPinListener> listeners = new ArrayList<GpioPinListener>();
    private final List<GpioTrigger> triggers = new ArrayList<GpioTrigger>();

    public GpioPinImpl(GpioController gpio, GpioProvider provider, Pin pin) {
        this.gpio = gpio;
        this.provider = provider;
        this.pin = pin;
        this.shutdownOptions = new GpioPinShutdownImpl();
    }

    @Override
    public Pin getPin() {
        return this.pin;
    }

    @Override
    public GpioProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null || this.name.length() == 0) {
            return this.pin.toString();
        }
        return this.name;
    }

    @Override
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.properties.containsKey(key)) {
            if (this.properties.get(key) == null || this.properties.get(key).isEmpty()) {
                return defaultValue;
            }
            return this.properties.get(key);
        }
        return defaultValue;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void removeProperty(String key) {
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public void export(PinMode mode) {
        this.provider.export(this.pin, mode);
    }

    @Override
    public void unexport() {
        this.provider.unexport(this.pin);
    }

    @Override
    public boolean isExported() {
        return this.provider.isExported(this.pin);
    }

    @Override
    public void setMode(PinMode mode) {
        this.provider.setMode(this.pin, mode);
    }

    @Override
    public PinMode getMode() {
        return this.provider.getMode(this.pin);
    }

    @Override
    public boolean isMode(PinMode mode) {
        return this.getMode() == mode;
    }

    @Override
    public void setPullResistance(PinPullResistance resistance) {
        this.provider.setPullResistance(this.pin, resistance);
    }

    @Override
    public PinPullResistance getPullResistance() {
        return this.provider.getPullResistance(this.pin);
    }

    @Override
    public boolean isPullResistance(PinPullResistance resistance) {
        return this.getPullResistance() == resistance;
    }

    @Override
    public void high() {
        this.setState(PinState.HIGH);
    }

    @Override
    public void low() {
        this.setState(PinState.LOW);
    }

    @Override
    public void toggle() {
        if (this.getState() == PinState.HIGH) {
            this.setState(PinState.LOW);
        } else {
            this.setState(PinState.HIGH);
        }
    }

    @Override
    public void blink(long delay) {
        this.blink(delay, PinState.HIGH);
    }

    @Override
    public void blink(long delay, PinState blinkState) {
        this.blink(delay, 0L, blinkState);
    }

    @Override
    public void blink(long delay, long duration) {
        this.blink(delay, duration, PinState.HIGH);
    }

    @Override
    public void blink(long delay, long duration, PinState blinkState) {
        GpioScheduledExecutorImpl.blink(this, delay, duration, blinkState);
    }

    @Override
    public Future<?> pulse(long duration) {
        return this.pulse(duration, false);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState) {
        return this.pulse(duration, pulseState, false);
    }

    @Override
    public Future<?> pulse(long duration, boolean blocking) {
        return this.pulse(duration, PinState.HIGH, blocking);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState, boolean blocking) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Pulse duration must be greater than 0 milliseconds.");
        }
        if (blocking) {
            this.setState(pulseState);
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Pulse blocking thread interrupted.", e);
            }
            this.setState(PinState.getInverseState(pulseState));
            return null;
        }
        return GpioScheduledExecutorImpl.pulse(this, duration, pulseState);
    }

    @Override
    public void setState(PinState state) {
        this.provider.setState(this.pin, state);
    }

    @Override
    public void setState(boolean state) {
        this.provider.setState(this.pin, state ? PinState.HIGH : PinState.LOW);
    }

    @Override
    public boolean isHigh() {
        return this.getState() == PinState.HIGH;
    }

    @Override
    public boolean isLow() {
        return this.getState() == PinState.LOW;
    }

    @Override
    public PinState getState() {
        return this.provider.getState(this.pin);
    }

    @Override
    public boolean isState(PinState state) {
        return this.getState() == state;
    }

    @Override
    public void setValue(double value) {
        this.provider.setValue(this.pin, value);
    }

    @Override
    public double getValue() {
        return this.provider.getValue(this.pin);
    }

    @Override
    public void setPwm(int value) {
        this.provider.setPwm(this.pin, value);
    }

    @Override
    public int getPwm() {
        return this.provider.getPwm(this.pin);
    }

    private synchronized void updateInterruptListener() {
        if (this.listeners.size() > 0 || this.triggers.size() > 0) {
            if (this.monitor == null) {
                this.monitor = new GpioEventMonitorExecutorImpl(this);
                this.provider.addListener(this.pin, this.monitor);
            }
        } else if (this.monitor != null) {
            this.provider.removeListener(this.pin, this.monitor);
            this.monitor = null;
        }
    }

    @Override
    public synchronized void addListener(GpioPinListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (GpioPinListener lsnr : listener) {
            this.listeners.add(lsnr);
        }
        this.updateInterruptListener();
    }

    @Override
    public synchronized void addListener(List<? extends GpioPinListener> listeners) {
        for (GpioPinListener gpioPinListener : listeners) {
            this.addListener(gpioPinListener);
        }
    }

    @Override
    public synchronized Collection<GpioPinListener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean hasListener(GpioPinListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (GpioPinListener lsnr : listener) {
            if (this.listeners.contains(lsnr)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void removeListener(GpioPinListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (GpioPinListener lsnr : listener) {
            this.listeners.remove(lsnr);
        }
        this.updateInterruptListener();
    }

    @Override
    public synchronized void removeListener(List<? extends GpioPinListener> listeners) {
        for (GpioPinListener gpioPinListener : listeners) {
            this.removeListener(gpioPinListener);
        }
    }

    @Override
    public synchronized void removeAllListeners() {
        for (int index = this.listeners.size() - 1; index >= 0; --index) {
            GpioPinListener listener = this.listeners.get(index);
            this.removeListener(listener);
        }
    }

    @Override
    public synchronized Collection<GpioTrigger> getTriggers() {
        return this.triggers;
    }

    @Override
    public synchronized void addTrigger(GpioTrigger ... trigger) {
        if (trigger == null || trigger.length == 0) {
            throw new IllegalArgumentException("Missing trigger argument.");
        }
        for (GpioTrigger trgr : trigger) {
            this.triggers.add(trgr);
        }
        this.updateInterruptListener();
    }

    @Override
    public synchronized void addTrigger(List<? extends GpioTrigger> triggers) {
        for (GpioTrigger gpioTrigger : triggers) {
            this.addTrigger(gpioTrigger);
        }
    }

    @Override
    public synchronized void removeTrigger(GpioTrigger ... trigger) {
        if (trigger == null || trigger.length == 0) {
            throw new IllegalArgumentException("Missing trigger argument.");
        }
        for (GpioTrigger trgr : trigger) {
            this.triggers.remove(trgr);
        }
        this.updateInterruptListener();
    }

    @Override
    public synchronized void removeTrigger(List<? extends GpioTrigger> triggers) {
        for (GpioTrigger gpioTrigger : triggers) {
            this.removeTrigger(gpioTrigger);
        }
    }

    @Override
    public synchronized void removeAllTriggers() {
        for (int index = this.triggers.size() - 1; index >= 0; --index) {
            GpioTrigger trigger = this.triggers.get(index);
            this.removeTrigger(trigger);
        }
    }

    public String toString() {
        if (this.name != null && !this.name.isEmpty()) {
            return String.format("\"%s\" <%s>", this.name, this.pin.toString());
        }
        return this.pin.toString();
    }

    @Override
    public GpioPinShutdown getShutdownOptions() {
        return this.shutdownOptions;
    }

    @Override
    public void setShutdownOptions(GpioPinShutdown options) {
        this.shutdownOptions.setUnexport(options.getUnexport());
        this.shutdownOptions.setState(options.getState());
        this.shutdownOptions.setMode(options.getMode());
        this.shutdownOptions.setPullResistor(options.getPullResistor());
    }

    @Override
    public void setShutdownOptions(Boolean unexport) {
        this.setShutdownOptions(unexport, null);
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state) {
        this.setShutdownOptions(unexport, state, null);
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state, PinPullResistance resistance) {
        this.setShutdownOptions(unexport, state, resistance, null);
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state, PinPullResistance resistance, PinMode mode) {
        this.shutdownOptions.setUnexport(unexport);
        this.shutdownOptions.setState(state);
        this.shutdownOptions.setMode(mode);
        this.shutdownOptions.setPullResistor(resistance);
    }
}

