/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial.impl;

import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialDataEvent;
import com.pi4j.io.serial.SerialDataListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SerialDataMonitorThread
extends Thread {
    public static final int DELAY = 100;
    private boolean exiting = false;
    private final Serial serial;
    private final List<SerialDataListener> listeners;

    public SerialDataMonitorThread(Serial serial, CopyOnWriteArrayList<SerialDataListener> listeners) {
        this.serial = serial;
        this.listeners = listeners;
    }

    public synchronized void exit() {
        this.exiting = true;
    }

    @Override
    public void run() {
        StringBuilder buffer = new StringBuilder();
        while (!this.exiting) {
            if (this.serial.isOpen() && this.serial.availableBytes() > 0) {
                buffer.setLength(0);
                while (this.serial.availableBytes() > 0) {
                    buffer.append(this.serial.read());
                }
                if (!this.listeners.isEmpty()) {
                    SerialDataEvent event = new SerialDataEvent(this.serial, buffer.toString());
                    for (SerialDataListener sdl : this.listeners) {
                        sdl.dataReceived(event);
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

