/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class NetworkInfo {
    private NetworkInfo() {
    }

    private static String[] executeCommand(String command) throws IOException, InterruptedException {
        return NetworkInfo.executeCommand(command, null);
    }

    private static String[] executeCommand(String command, String split) throws IOException, InterruptedException {
        ArrayList<String> result = new ArrayList<String>();
        Process p = Runtime.getRuntime().exec(command);
        p.waitFor();
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = reader.readLine();
        while (line != null) {
            if (!line.isEmpty()) {
                if (split == null || split.isEmpty()) {
                    result.add(line.trim());
                } else {
                    String[] parts;
                    for (String part : parts = line.trim().split(split)) {
                        if (part == null || part.isEmpty()) continue;
                        result.add(part.trim());
                    }
                }
            }
            line = reader.readLine();
        }
        if (result.size() > 0) {
            return result.toArray(new String[0]);
        }
        return new String[0];
    }

    public static String getHostname() throws IOException, InterruptedException {
        return NetworkInfo.executeCommand("hostname --short")[0];
    }

    public static String getFQDN() throws IOException, InterruptedException {
        return NetworkInfo.executeCommand("hostname --fqdn")[0];
    }

    public static String[] getIPAddresses() throws IOException, InterruptedException {
        return NetworkInfo.executeCommand("hostname --all-ip-addresses", " ");
    }

    public static String getIPAddress() throws IOException, InterruptedException {
        return NetworkInfo.executeCommand("hostname --ip-address")[0];
    }

    public static String[] getFQDNs() throws IOException, InterruptedException {
        return NetworkInfo.executeCommand("hostname --all-fqdns", " ");
    }

    public static String[] getNameservers() throws IOException, InterruptedException {
        String[] nameservers = NetworkInfo.executeCommand("cat /etc/resolv.conf");
        ArrayList<String> result = new ArrayList<String>();
        for (String nameserver : nameservers) {
            if (!nameserver.startsWith("nameserver")) continue;
            result.add(nameserver.substring(11).trim());
        }
        return result.toArray(new String[0]);
    }
}

