/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.concurrent;

import com.pi4j.concurrent.ExecutorServiceFactory;
import com.pi4j.concurrent.ScheduledExecutorServiceWrapper;
import com.pi4j.concurrent.ShutdownDisabledExecutorWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultExecutorServiceFactory
implements ExecutorServiceFactory {
    private static int MAX_THREADS_IN_POOL = 25;
    private static List<ExecutorService> singleThreadExecutorServices = new ArrayList<ExecutorService>();

    private static ScheduledExecutorService getInternalScheduledExecutorService() {
        return ScheduledExecutorServiceHolder.heldExecutor;
    }

    private static ScheduledExecutorServiceWrapper getScheduledExecutorServiceWrapper() {
        return ScheduledExecutorServiceWrapperHolder.heldWrapper;
    }

    private static ExecutorService getInternalGpioExecutorService() {
        return GpioEventExecutorServiceHolder.heldExecutor;
    }

    private static ExecutorService getGpioEventExecutorServiceWrapper() {
        return GpioEventExecutorServiceWrapperHolder.heldWrapper;
    }

    private static ThreadFactory getThreadFactory(final String nameFormat) {
        final ThreadFactory defaultThreadFactory = Executors.privilegedThreadFactory();
        return new ThreadFactory(){
            final AtomicLong count;
            {
                this.count = nameFormat != null ? new AtomicLong(0L) : null;
            }

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = defaultThreadFactory.newThread(runnable);
                if (nameFormat != null) {
                    thread.setName(String.format(nameFormat, this.count.getAndIncrement()));
                }
                return thread;
            }
        };
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return DefaultExecutorServiceFactory.getScheduledExecutorServiceWrapper();
    }

    @Override
    public ExecutorService getGpioEventExecutorService() {
        return DefaultExecutorServiceFactory.getGpioEventExecutorServiceWrapper();
    }

    @Override
    public ExecutorService newSingleThreadExecutorService() {
        ExecutorService singleThreadExecutorService = Executors.newSingleThreadExecutor(DefaultExecutorServiceFactory.getThreadFactory("pi4j-single-executor-%d"));
        singleThreadExecutorServices.add(singleThreadExecutorService);
        return singleThreadExecutorService;
    }

    @Override
    public void shutdown() {
        for (ExecutorService singleThreadExecutorService : singleThreadExecutorServices) {
            this.shutdownExecutor(singleThreadExecutorService);
        }
        this.shutdownExecutor(DefaultExecutorServiceFactory.getInternalScheduledExecutorService());
        this.shutdownExecutor(DefaultExecutorServiceFactory.getInternalGpioExecutorService());
    }

    private void shutdownExecutor(ExecutorService executor) {
        if (executor != null && !executor.isShutdown()) {
            executor.shutdownNow();
        }
    }

    static /* synthetic */ int access$000() {
        return MAX_THREADS_IN_POOL;
    }

    static /* synthetic */ ThreadFactory access$100(String x0) {
        return DefaultExecutorServiceFactory.getThreadFactory(x0);
    }

    static /* synthetic */ ScheduledExecutorService access$200() {
        return DefaultExecutorServiceFactory.getInternalScheduledExecutorService();
    }

    static /* synthetic */ ExecutorService access$300() {
        return DefaultExecutorServiceFactory.getInternalGpioExecutorService();
    }

    private static class GpioEventExecutorServiceWrapperHolder {
        static final ExecutorService heldWrapper = new ShutdownDisabledExecutorWrapper(DefaultExecutorServiceFactory.access$300());

        private GpioEventExecutorServiceWrapperHolder() {
        }
    }

    private static class GpioEventExecutorServiceHolder {
        static final ExecutorService heldExecutor = Executors.newCachedThreadPool(DefaultExecutorServiceFactory.access$100("pi4j-gpio-event-executor-%d"));

        private GpioEventExecutorServiceHolder() {
        }
    }

    private static class ScheduledExecutorServiceWrapperHolder {
        static final ScheduledExecutorServiceWrapper heldWrapper = new ScheduledExecutorServiceWrapper(DefaultExecutorServiceFactory.access$200());

        private ScheduledExecutorServiceWrapperHolder() {
        }
    }

    private static class ScheduledExecutorServiceHolder {
        static final ScheduledExecutorService heldExecutor = Executors.newScheduledThreadPool(DefaultExecutorServiceFactory.access$000(), DefaultExecutorServiceFactory.access$100("pi4j-scheduled-executor-%d"));

        private ScheduledExecutorServiceHolder() {
        }
    }
}

