/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderPinCache;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.exception.InvalidPinException;
import com.pi4j.io.gpio.exception.InvalidPinModeException;
import com.pi4j.io.gpio.exception.UnsupportedPinModeException;
import com.pi4j.io.gpio.exception.UnsupportedPinPullResistanceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GpioProviderBase
implements GpioProvider {
    public static final int DEFAULT_CACHE_SIZE = 100;
    protected final Map<Pin, List<PinListener>> listeners = new ConcurrentHashMap<Pin, List<PinListener>>();
    protected GpioProviderPinCache[] cache = new GpioProviderPinCache[100];
    protected boolean isshutdown = false;

    @Override
    public abstract String getName();

    @Override
    public boolean hasPin(Pin pin) {
        return pin.getProvider().equals(this.getName());
    }

    protected GpioProviderPinCache getPinCache(Pin pin) {
        GpioProviderPinCache pc;
        int address = pin.getAddress();
        if (address >= this.cache.length) {
            this.cache = Arrays.copyOf(this.cache, address + 100);
        }
        if ((pc = this.cache[address]) == null) {
            GpioProviderPinCache gpioProviderPinCache = new GpioProviderPinCache(pin);
            this.cache[pin.getAddress()] = gpioProviderPinCache;
            pc = gpioProviderPinCache;
        }
        return pc;
    }

    @Override
    public void export(Pin pin, PinMode mode, PinState defaultState) {
        this.export(pin, mode);
        if (defaultState != null && mode == PinMode.DIGITAL_OUTPUT) {
            this.setState(pin, defaultState);
        }
    }

    @Override
    public void export(Pin pin, PinMode mode) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        if (!pin.getSupportedPinModes().contains((Object)mode)) {
            throw new UnsupportedPinModeException(pin, mode);
        }
        this.getPinCache(pin).setExported(true);
        this.getPinCache(pin).setMode(mode);
    }

    @Override
    public boolean isExported(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        return this.getPinCache(pin).isExported();
    }

    @Override
    public void unexport(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        this.getPinCache(pin).setExported(false);
    }

    @Override
    public void setMode(Pin pin, PinMode mode) {
        if (!pin.getSupportedPinModes().contains((Object)mode)) {
            throw new InvalidPinModeException(pin, "Invalid pin mode [" + mode.getName() + "]; pin [" + pin.getName() + "] does not support this mode.");
        }
        if (!pin.getSupportedPinModes().contains((Object)mode)) {
            throw new UnsupportedPinModeException(pin, mode);
        }
        this.getPinCache(pin).setMode(mode);
    }

    @Override
    public PinMode getMode(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        return this.getPinCache(pin).getMode();
    }

    @Override
    public void setPullResistance(Pin pin, PinPullResistance resistance) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        if (!pin.getSupportedPinPullResistance().contains((Object)resistance)) {
            throw new UnsupportedPinPullResistanceException(pin, resistance);
        }
        this.getPinCache(pin).setResistance(resistance);
    }

    @Override
    public PinPullResistance getPullResistance(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        return this.getPinCache(pin).getResistance();
    }

    @Override
    public void setState(Pin pin, PinState state) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        GpioProviderPinCache pinCache = this.getPinCache(pin);
        if (pinCache.getMode() != PinMode.DIGITAL_OUTPUT) {
            throw new InvalidPinModeException(pin, "Invalid pin mode on pin [" + pin.getName() + "]; cannot setState() when pin mode is [" + pinCache.getMode().getName() + "]");
        }
        this.dispatchPinDigitalStateChangeEvent(pin, state);
        pinCache.setState(state);
    }

    @Override
    public PinState getState(Pin pin) {
        PinMode mode = this.getMode(pin);
        if (!PinMode.allDigital().contains((Object)mode)) {
            throw new InvalidPinModeException(pin, "Invalid pin mode on pin [" + pin.getName() + "]; cannot getState() when pin mode is [" + mode.getName() + "]");
        }
        return this.getPinCache(pin).getState();
    }

    @Override
    public void setValue(Pin pin, double value) {
        PinMode mode = this.getMode(pin);
        if (!PinMode.allOutput().contains((Object)mode)) {
            throw new InvalidPinModeException(pin, "Invalid pin mode on pin [" + pin.getName() + "]; cannot setValue(" + value + ") when pin mode is [" + mode.getName() + "]");
        }
        this.dispatchPinAnalogValueChangeEvent(pin, value);
        this.getPinCache(pin).setAnalogValue(value);
    }

    @Override
    public double getValue(Pin pin) {
        PinMode mode = this.getMode(pin);
        if (mode == PinMode.DIGITAL_OUTPUT) {
            return this.getState(pin).getValue();
        }
        return this.getPinCache(pin).getAnalogValue();
    }

    @Override
    public void setPwm(Pin pin, int value) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (mode != PinMode.PWM_OUTPUT || mode != PinMode.SOFT_PWM_OUTPUT) {
            throw new InvalidPinModeException(pin, "Invalid pin mode [" + mode.getName() + "]; unable to setPwm(" + value + ")");
        }
        this.getPinCache(pin).setPwmValue(value);
    }

    @Override
    public void setPwmRange(Pin pin, int range) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPwm(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        return this.getPinCache(pin).getPwmValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Pin pin, PinListener listener) {
        Map<Pin, List<PinListener>> map = this.listeners;
        synchronized (map) {
            List<PinListener> lsnrs;
            if (!this.listeners.containsKey(pin)) {
                this.listeners.put(pin, new ArrayList());
            }
            if (!(lsnrs = this.listeners.get(pin)).contains(listener)) {
                lsnrs.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Pin pin, PinListener listener) {
        Map<Pin, List<PinListener>> map = this.listeners;
        synchronized (map) {
            if (this.listeners.containsKey(pin)) {
                List<PinListener> lsnrs = this.listeners.get(pin);
                if (lsnrs.contains(listener)) {
                    lsnrs.remove(listener);
                }
                if (lsnrs.isEmpty()) {
                    this.listeners.remove(pin);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListeners() {
        Map<Pin, List<PinListener>> map = this.listeners;
        synchronized (map) {
            ArrayList<Pin> pins_copy = new ArrayList<Pin>(this.listeners.keySet());
            for (Pin pin : pins_copy) {
                List<PinListener> lsnrs;
                if (!this.listeners.containsKey(pin) || (lsnrs = this.listeners.get(pin)).isEmpty()) continue;
                ArrayList<PinListener> lsnrs_copy = new ArrayList<PinListener>(lsnrs);
                for (int index = lsnrs_copy.size() - 1; index >= 0; --index) {
                    PinListener listener = (PinListener)lsnrs_copy.get(index);
                    this.removeListener(pin, listener);
                }
            }
        }
    }

    protected void dispatchPinDigitalStateChangeEvent(Pin pin, PinState state) {
        if (this.listeners.containsKey(pin)) {
            for (PinListener listener : this.listeners.get(pin)) {
                listener.handlePinEvent(new PinDigitalStateChangeEvent((Object)this, pin, state));
            }
        }
    }

    protected void dispatchPinAnalogValueChangeEvent(Pin pin, double value) {
        if (this.listeners.containsKey(pin)) {
            for (PinListener listener : this.listeners.get(pin)) {
                listener.handlePinEvent(new PinAnalogValueChangeEvent((Object)this, pin, value));
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        this.removeAllListeners();
        this.isshutdown = true;
    }

    @Override
    public boolean isShutdown() {
        return this.isshutdown;
    }
}

