/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.WiringPiGpioProviderBase;
import com.pi4j.io.gpio.exception.InvalidPinModeException;
import com.pi4j.jni.AnalogInputEvent;
import com.pi4j.jni.AnalogInputListener;
import com.pi4j.jni.AnalogInputMonitor;
import com.pi4j.platform.Platform;
import com.pi4j.wiringpi.Gpio;
import com.pi4j.wiringpi.GpioInterrupt;
import com.pi4j.wiringpi.GpioInterruptListener;
import java.util.List;

public class OdroidGpioProvider
extends WiringPiGpioProviderBase
implements GpioProvider,
GpioInterruptListener,
AnalogInputListener {
    public static final String NAME = "Odroid GPIO Provider";
    public static final int AIN_ADDRESS_OFFSET = 47;
    public static final int DEFAULT_ANALOG_INPUT_POLLING_RATE = 50;
    public static final double DEFAULT_ANALOG_INPUT_LISTENER_CHANGE_THRESHOLD = 0.0;
    protected static int analogInputPollingRate = 50;
    protected static double analogInputListenerChangeThreshold = 0.0;

    public static int getAnalogInputPollingRate() {
        return analogInputPollingRate;
    }

    public static double getAnalogInputListenerChangeThreshold() {
        return analogInputListenerChangeThreshold;
    }

    public static void setAnalogInputPollingRate(int milliseconds) {
        if (milliseconds > 0) {
            analogInputPollingRate = milliseconds;
        }
    }

    public static void setAnalogInputListenerChangeThreshold(double threshold) {
        if (threshold > 0.0) {
            analogInputListenerChangeThreshold = threshold;
        }
    }

    public OdroidGpioProvider() {
        System.setProperty("pi4j.platform", Platform.ODROID.id());
        Gpio.wiringPiSetup();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void export(Pin pin, PinMode mode, PinState defaultState) {
        if (mode == PinMode.ANALOG_INPUT) {
            this.setMode(pin, mode);
            return;
        }
        super.export(pin, mode, defaultState);
    }

    @Override
    public boolean isExported(Pin pin) {
        if (this.getMode(pin) == PinMode.ANALOG_INPUT) {
            return false;
        }
        return super.isExported(pin);
    }

    @Override
    public void unexport(Pin pin) {
        if (pin.getSupportedPinModes().contains((Object)PinMode.ANALOG_INPUT)) {
            return;
        }
        super.unexport(pin);
    }

    @Override
    public void setMode(Pin pin, PinMode mode) {
        if (mode == PinMode.ANALOG_INPUT) {
            if (!pin.getSupportedPinModes().contains((Object)mode)) {
                throw new InvalidPinModeException(pin, "Invalid pin mode [" + mode.getName() + "]; pin [" + pin.getName() + "] does not support this mode.");
            }
            OdroidGpioProvider.pinModeCache[pin.getAddress()] = mode;
            this.getPinCache(pin).setMode(mode);
            return;
        }
        super.setMode(pin, mode);
    }

    @Override
    public double getValue(Pin pin) {
        PinMode mode = this.getMode(pin);
        if (mode == PinMode.ANALOG_INPUT) {
            double value = Gpio.analogRead(pin.getAddress() - 47);
            this.getPinCache(pin).setAnalogValue(value);
            return value;
        }
        return super.getValue(pin);
    }

    @Override
    public void pinValueChange(AnalogInputEvent event) {
        int analogPinAddress = event.getPin() + 47;
        for (Pin pin : this.listeners.keySet()) {
            if (pin.getAddress() != analogPinAddress) continue;
            this.dispatchPinAnalogValueChangeEvent(pin, event.getValue());
        }
    }

    @Override
    protected void updateInterruptListener(Pin pin) {
        if (this.listeners.size() > 0) {
            if (!GpioInterrupt.hasListener(this)) {
                GpioInterrupt.addListener(this);
            }
            if (pinModeCache[pin.getAddress()] == PinMode.DIGITAL_INPUT) {
                if (this.listeners.containsKey(pin) && ((List)this.listeners.get(pin)).size() > 0) {
                    GpioInterrupt.enablePinStateChangeCallback(pin.getAddress());
                } else {
                    GpioInterrupt.disablePinStateChangeCallback(pin.getAddress());
                }
            }
            if (!AnalogInputMonitor.hasListener(this)) {
                AnalogInputMonitor.addListener(this);
            }
            if (pinModeCache[pin.getAddress()] == PinMode.ANALOG_INPUT) {
                int analogPinAddress = pin.getAddress() - 47;
                if (this.listeners.containsKey(pin) && ((List)this.listeners.get(pin)).size() > 0) {
                    AnalogInputMonitor.enablePinValueChangeCallback(analogPinAddress, analogInputPollingRate, analogInputListenerChangeThreshold);
                } else {
                    AnalogInputMonitor.disablePinValueChangeCallback(analogPinAddress);
                }
            }
        } else {
            GpioInterrupt.disablePinStateChangeCallback(pin.getAddress());
            if (GpioInterrupt.hasListener(this)) {
                GpioInterrupt.removeListener(this);
            }
            int analogPinAddress = pin.getAddress() - 47;
            AnalogInputMonitor.disablePinValueChangeCallback(analogPinAddress);
            if (AnalogInputMonitor.hasListener(this)) {
                AnalogInputMonitor.removeListener(this);
            }
        }
    }
}

