/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinEdge;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinProvider;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.system.SystemInfo;
import java.util.ArrayList;
import java.util.EnumSet;

public class RaspiPin
extends PinProvider {
    public static final Pin GPIO_00 = RaspiPin.createDigitalPin(0, "GPIO 0");
    public static final Pin GPIO_01 = RaspiPin.createDigitalAndPwmPin(1, "GPIO 1");
    public static final Pin GPIO_02 = RaspiPin.createDigitalPin(2, "GPIO 2");
    public static final Pin GPIO_03 = RaspiPin.createDigitalPin(3, "GPIO 3");
    public static final Pin GPIO_04 = RaspiPin.createDigitalPin(4, "GPIO 4");
    public static final Pin GPIO_05 = RaspiPin.createDigitalPin(5, "GPIO 5");
    public static final Pin GPIO_06 = RaspiPin.createDigitalPin(6, "GPIO 6");
    public static final Pin GPIO_07 = RaspiPin.createDigitalPin(7, "GPIO 7");
    public static final Pin GPIO_08 = RaspiPin.createDigitalPinNoPullDown(8, "GPIO 8");
    public static final Pin GPIO_09 = RaspiPin.createDigitalPinNoPullDown(9, "GPIO 9");
    public static final Pin GPIO_10 = RaspiPin.createDigitalPin(10, "GPIO 10");
    public static final Pin GPIO_11 = RaspiPin.createDigitalPin(11, "GPIO 11");
    public static final Pin GPIO_12 = RaspiPin.createDigitalPin(12, "GPIO 12");
    public static final Pin GPIO_13 = RaspiPin.createDigitalPin(13, "GPIO 13");
    public static final Pin GPIO_14 = RaspiPin.createDigitalPin(14, "GPIO 14");
    public static final Pin GPIO_15 = RaspiPin.createDigitalPin(15, "GPIO 15");
    public static final Pin GPIO_16 = RaspiPin.createDigitalPin(16, "GPIO 16");
    public static final Pin GPIO_17 = RaspiPin.createDigitalPin(17, "GPIO 17");
    public static final Pin GPIO_18 = RaspiPin.createDigitalPin(18, "GPIO 18");
    public static final Pin GPIO_19 = RaspiPin.createDigitalPin(19, "GPIO 19");
    public static final Pin GPIO_20 = RaspiPin.createDigitalPin(20, "GPIO 20");
    public static final Pin GPIO_21 = RaspiPin.createDigitalPin(21, "GPIO 21");
    public static final Pin GPIO_22 = RaspiPin.createDigitalPin(22, "GPIO 22");
    public static final Pin GPIO_23 = RaspiPin.createDigitalAndPwmPin(23, "GPIO 23");
    public static final Pin GPIO_24 = RaspiPin.createDigitalAndPwmPin(24, "GPIO 24");
    public static final Pin GPIO_25 = RaspiPin.createDigitalPin(25, "GPIO 25");
    public static final Pin GPIO_26 = RaspiPin.createDigitalAndPwmPin(26, "GPIO 26");
    public static final Pin GPIO_27 = RaspiPin.createDigitalPin(27, "GPIO 27");
    public static final Pin GPIO_28 = RaspiPin.createDigitalPin(28, "GPIO 28");
    public static final Pin GPIO_29 = RaspiPin.createDigitalPin(29, "GPIO 29");
    public static final Pin GPIO_30 = RaspiPin.createDigitalPinNoPullDown(30, "GPIO 30");
    public static final Pin GPIO_31 = RaspiPin.createDigitalPinNoPullDown(31, "GPIO 31");

    protected static Pin createDigitalPinNoPullDown(int address, String name) {
        return RaspiPin.createDigitalPin("RaspberryPi GPIO Provider", address, name, EnumSet.of(PinPullResistance.OFF, PinPullResistance.PULL_UP), PinEdge.all());
    }

    protected static Pin createDigitalPin(int address, String name) {
        return RaspiPin.createDigitalPin("RaspberryPi GPIO Provider", address, name);
    }

    protected static Pin createDigitalAndPwmPin(int address, String name) {
        return RaspiPin.createDigitalAndPwmPin("RaspberryPi GPIO Provider", address, name);
    }

    public static Pin getPinByName(String name) {
        return PinProvider.getPinByName(name);
    }

    public static Pin getPinByAddress(int address) {
        return PinProvider.getPinByAddress(address);
    }

    public static Pin[] allPins() {
        return PinProvider.allPins();
    }

    public static Pin[] allPins(PinMode ... mode) {
        return PinProvider.allPins(mode);
    }

    public static Pin[] allPins(SystemInfo.BoardType board) {
        ArrayList<Pin> pins = new ArrayList<Pin>();
        pins.add(GPIO_00);
        pins.add(GPIO_01);
        pins.add(GPIO_02);
        pins.add(GPIO_03);
        pins.add(GPIO_04);
        pins.add(GPIO_05);
        pins.add(GPIO_06);
        pins.add(GPIO_07);
        pins.add(GPIO_08);
        pins.add(GPIO_09);
        pins.add(GPIO_10);
        pins.add(GPIO_11);
        pins.add(GPIO_12);
        pins.add(GPIO_13);
        pins.add(GPIO_14);
        pins.add(GPIO_15);
        pins.add(GPIO_16);
        if (board == SystemInfo.BoardType.RaspberryPi_B_Rev1) {
            return pins.toArray(new Pin[0]);
        }
        if (board == SystemInfo.BoardType.RaspberryPi_A || board == SystemInfo.BoardType.RaspberryPi_B_Rev2) {
            pins.add(GPIO_17);
            pins.add(GPIO_18);
            pins.add(GPIO_19);
            pins.add(GPIO_20);
        } else {
            pins.add(GPIO_21);
            pins.add(GPIO_22);
            pins.add(GPIO_23);
            pins.add(GPIO_24);
            pins.add(GPIO_25);
            pins.add(GPIO_26);
            pins.add(GPIO_27);
            pins.add(GPIO_28);
            pins.add(GPIO_29);
            pins.add(GPIO_30);
            pins.add(GPIO_31);
        }
        return pins.toArray(new Pin[0]);
    }
}

