/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial.impl;

import com.pi4j.io.serial.Baud;
import com.pi4j.io.serial.DataBits;
import com.pi4j.io.serial.FlowControl;
import com.pi4j.io.serial.Parity;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.SerialDataEvent;
import com.pi4j.io.serial.SerialDataEventListener;
import com.pi4j.io.serial.SerialFactory;
import com.pi4j.io.serial.StopBits;
import com.pi4j.io.serial.impl.AbstractSerialDataReaderWriter;
import com.pi4j.io.serial.impl.SerialByteBuffer;
import com.pi4j.io.serial.tasks.SerialDataEventDispatchTaskImpl;
import com.pi4j.jni.SerialInterrupt;
import com.pi4j.jni.SerialInterruptEvent;
import com.pi4j.jni.SerialInterruptListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

public class SerialImpl
extends AbstractSerialDataReaderWriter
implements Serial {
    protected int fileDescriptor = -1;
    protected final CopyOnWriteArrayList<SerialDataEventListener> listeners = new CopyOnWriteArrayList();
    protected final ExecutorService executor = SerialFactory.getExecutorServiceFactory().newSingleThreadExecutorService();
    protected final SerialByteBuffer receiveBuffer = new SerialByteBuffer();
    protected boolean bufferingDataReceived = true;

    public SerialImpl() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    @Override
    public void open(String device, int baud, int dataBits, int parity, int stopBits, int flowControl) throws IOException {
        byte[] initial_data;
        this.fileDescriptor = com.pi4j.jni.Serial.open(device, baud, dataBits, parity, stopBits, flowControl);
        int available = com.pi4j.jni.Serial.available(this.fileDescriptor);
        if (available > 0 && (initial_data = com.pi4j.jni.Serial.read(this.fileDescriptor, available)).length > 0) {
            try {
                this.receiveBuffer.write(initial_data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SerialInterrupt.addListener(this.fileDescriptor, new SerialInterruptListener(){

            @Override
            public void onDataReceive(SerialInterruptEvent event) {
                if (event.getLength() <= 0) {
                    return;
                }
                try {
                    SerialDataEvent sde = null;
                    if (SerialImpl.this.isBufferingDataReceived()) {
                        SerialImpl.this.receiveBuffer.write(event.getData());
                        sde = new SerialDataEvent(SerialImpl.this);
                    } else {
                        sde = new SerialDataEvent(SerialImpl.this, event.getData());
                    }
                    SerialImpl.this.executor.execute(new SerialDataEventDispatchTaskImpl(sde, SerialImpl.this.listeners));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        if (this.fileDescriptor == -1) {
            throw new IOException("Cannot open serial port");
        }
    }

    @Override
    public void open(String device, int baud) throws IOException {
        this.open(device, baud, com.pi4j.jni.Serial.DATA_BITS_8, com.pi4j.jni.Serial.PARITY_NONE, com.pi4j.jni.Serial.STOP_BITS_1, com.pi4j.jni.Serial.FLOW_CONTROL_NONE);
    }

    @Override
    public void open(String device, Baud baud, DataBits dataBits, Parity parity, StopBits stopBits, FlowControl flowControl) throws IOException {
        this.open(device, baud.getValue(), dataBits.getValue(), parity.getIndex(), stopBits.getValue(), flowControl.getIndex());
    }

    @Override
    public void open(SerialConfig serialConfig) throws IOException {
        this.open(serialConfig.device(), serialConfig.baud().getValue(), serialConfig.dataBits().getValue(), serialConfig.parity().getIndex(), serialConfig.stopBits().getValue(), serialConfig.flowControl().getIndex());
    }

    @Override
    public boolean isOpen() {
        return this.fileDescriptor >= 0;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public void close() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'close()'.");
        }
        SerialInterrupt.removeListener(this.fileDescriptor);
        com.pi4j.jni.Serial.close(this.fileDescriptor);
        this.fileDescriptor = -1;
    }

    @Override
    public void flush() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'flush()'.");
        }
        com.pi4j.jni.Serial.flush(this.fileDescriptor);
    }

    @Override
    public void discardInput() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'discardInput()'.");
        }
        com.pi4j.jni.Serial.discardInput(this.fileDescriptor);
    }

    @Override
    public void discardOutput() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'discardOutput()'.");
        }
        com.pi4j.jni.Serial.discardOutput(this.fileDescriptor);
    }

    @Override
    public void discardAll() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'discardAll()'.");
        }
        com.pi4j.jni.Serial.discardAll(this.fileDescriptor);
    }

    @Override
    public void sendBreak(int duration) throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'sendBreak()'.");
        }
        com.pi4j.jni.Serial.sendBreak(this.fileDescriptor, duration);
    }

    @Override
    public void sendBreak() throws IllegalStateException, IOException {
        this.sendBreak(0);
    }

    @Override
    public void setBreak(boolean enabled) throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'setBreak()'.");
        }
        com.pi4j.jni.Serial.setBreak(this.fileDescriptor, enabled);
    }

    @Override
    public void setRTS(boolean enabled) throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'setRTS()'.");
        }
        com.pi4j.jni.Serial.setRTS(this.fileDescriptor, enabled);
    }

    @Override
    public void setDTR(boolean enabled) throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'setDTR()'.");
        }
        com.pi4j.jni.Serial.setDTR(this.fileDescriptor, enabled);
    }

    @Override
    public boolean getRTS() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'getRTS()'.");
        }
        return com.pi4j.jni.Serial.getRTS(this.fileDescriptor);
    }

    @Override
    public boolean getDTR() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'getDTR()'.");
        }
        return com.pi4j.jni.Serial.getDTR(this.fileDescriptor);
    }

    @Override
    public boolean getCTS() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'getCTS()'.");
        }
        return com.pi4j.jni.Serial.getCTS(this.fileDescriptor);
    }

    @Override
    public boolean getDSR() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'getDSR()'.");
        }
        return com.pi4j.jni.Serial.getDSR(this.fileDescriptor);
    }

    @Override
    public boolean getRI() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'getRI()'.");
        }
        return com.pi4j.jni.Serial.getRI(this.fileDescriptor);
    }

    @Override
    public boolean getCD() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'getCD()'.");
        }
        return com.pi4j.jni.Serial.getCD(this.fileDescriptor);
    }

    @Override
    public int available() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'available()'.");
        }
        return this.receiveBuffer.getInputStream().available();
    }

    @Override
    public byte[] read() throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'read()'.");
        }
        byte[] buffer = new byte[this.available()];
        this.receiveBuffer.getInputStream().read(buffer);
        return buffer;
    }

    @Override
    public byte[] read(int length) throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'read()'.");
        }
        byte[] buffer = new byte[length];
        this.receiveBuffer.getInputStream().read(buffer, 0, length);
        return buffer;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IllegalStateException, IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'write()'.");
        }
        com.pi4j.jni.Serial.write(this.fileDescriptor, data, offset, length);
    }

    @Override
    public synchronized void addListener(SerialDataEventListener ... listener) {
        Collections.addAll(this.listeners, listener);
    }

    @Override
    public synchronized void removeListener(SerialDataEventListener ... listener) {
        for (SerialDataEventListener lsnr : listener) {
            this.listeners.remove(lsnr);
        }
    }

    @Override
    public int getFileDescriptor() {
        return this.fileDescriptor;
    }

    @Override
    public InputStream getInputStream() {
        return this.receiveBuffer.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return new SerialOutputStream();
    }

    @Override
    public boolean isBufferingDataReceived() {
        return this.bufferingDataReceived;
    }

    @Override
    public void setBufferingDataReceived(boolean enabled) {
        this.bufferingDataReceived = enabled;
    }

    private class SerialInputStream
    extends InputStream {
        private SerialInputStream() {
        }

        @Override
        public int read() throws IOException {
            return 0;
        }
    }

    private class SerialOutputStream
    extends OutputStream {
        private SerialOutputStream() {
        }

        @Override
        public void write(byte[] b) throws IOException {
            SerialImpl.this.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            SerialImpl.this.write((byte)b);
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            SerialImpl.this.write(b, offset, length);
        }

        @Override
        public void flush() throws IOException {
            SerialImpl.this.flush();
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            if (SerialImpl.this.isOpen()) {
                try {
                    SerialImpl.this.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            SerialInterrupt.removeListener(SerialImpl.this.fileDescriptor);
            SerialFactory.shutdown();
        }
    }
}

