/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.w1;

import com.pi4j.io.w1.W1Device;
import com.pi4j.io.w1.W1DeviceType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class W1Master {
    private final Logger log = Logger.getLogger(W1Master.class.getName());
    private final List<W1DeviceType> deviceTypes = new ArrayList<W1DeviceType>();
    private final Map<String, W1DeviceType> deviceTypeMap = new LinkedHashMap<String, W1DeviceType>();
    private File masterDir = new File("/sys/bus/w1/devices");
    private final List<W1Device> devices = new CopyOnWriteArrayList<W1Device>();

    public W1Master() {
        this.init(null);
    }

    public W1Master(ClassLoader classloader) {
        this.init(classloader);
    }

    public W1Master(String masterDir) {
        this.masterDir = new File(masterDir);
        this.init(null);
    }

    public W1Master(String masterDir, ClassLoader classloader) {
        this.masterDir = new File(masterDir);
        this.init(classloader);
    }

    private void init(ClassLoader classloader) {
        ServiceLoader<W1DeviceType> w1DeviceTypes = classloader == null ? ServiceLoader.load(W1DeviceType.class) : ServiceLoader.load(W1DeviceType.class, classloader);
        for (W1DeviceType w1DeviceType : w1DeviceTypes) {
            this.deviceTypes.add(w1DeviceType);
            String deviceFamily = Integer.toHexString(w1DeviceType.getDeviceFamilyCode()).toUpperCase();
            this.deviceTypeMap.put(deviceFamily, w1DeviceType);
        }
        this.devices.addAll(this.readDevices());
    }

    public void checkDeviceChanges() {
        ArrayList refreshedDevices = new ArrayList();
        ArrayList<W1Device> removedDevices = new ArrayList<W1Device>();
        refreshedDevices.addAll(this.readDevices());
        for (W1Device device : this.devices) {
            if (refreshedDevices.contains(device)) continue;
            removedDevices.add(device);
        }
        refreshedDevices.removeAll(this.devices);
        int newCount = refreshedDevices.size();
        int removedCount = removedDevices.size();
        if (newCount > 0) {
            this.log.fine("found " + newCount + " new device(s): " + refreshedDevices);
        }
        if (removedCount > 0) {
            this.log.fine("removed " + removedCount + " device(s): " + removedDevices);
        }
        this.devices.addAll(refreshedDevices);
        this.devices.removeAll(removedDevices);
    }

    public Collection<W1DeviceType> getDeviceTypes() {
        return this.deviceTypes;
    }

    public Map<String, W1DeviceType> getDeviceTypeMap() {
        return this.deviceTypeMap;
    }

    private List<File> getDeviceDirs() {
        File[] slaveDevices = this.masterDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.contains("w1_bus_master");
            }
        });
        if (slaveDevices != null) {
            return Arrays.asList(slaveDevices);
        }
        return Collections.emptyList();
    }

    public List<String> getDeviceIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (File deviceDir : this.getDeviceDirs()) {
            ids.add(deviceDir.getName());
        }
        return ids;
    }

    public List<W1Device> getDevices() {
        return Collections.unmodifiableList(this.devices);
    }

    public <T extends W1Device> List<T> getDevices(int deviceFamilyId) {
        ArrayList<W1Device> filteredDevices = new ArrayList<W1Device>();
        for (W1Device device : this.devices) {
            if (deviceFamilyId != device.getFamilyId()) continue;
            filteredDevices.add(device);
        }
        return filteredDevices;
    }

    <T extends W1Device> List<T> readDevices() {
        ArrayList<W1Device> devices = new ArrayList<W1Device>();
        for (File deviceDir : this.getDeviceDirs()) {
            String id = deviceDir.getName().substring(0, 2).toUpperCase();
            W1DeviceType w1DeviceType = this.deviceTypeMap.get(id);
            if (w1DeviceType != null) {
                W1Device w1Device = w1DeviceType.create(deviceDir);
                devices.add(w1Device);
                continue;
            }
            this.log.info("no device type for [" + id + "] found - ignoring");
        }
        return devices;
    }

    public <T> List<T> getDevices(Class<T> type) {
        List<W1Device> allDevices = this.getDevices();
        ArrayList<W1Device> filteredDevices = new ArrayList<W1Device>();
        for (W1Device device : allDevices) {
            if (!type.isAssignableFrom(device.getClass())) continue;
            filteredDevices.add(device);
        }
        return filteredDevices;
    }

    public <T extends W1Device> List<T> getW1Devices(Class<T> type) {
        for (W1DeviceType deviceType : this.deviceTypes) {
            if (!deviceType.getDeviceClass().equals(type)) continue;
            return this.getDevices(deviceType.getDeviceFamilyCode());
        }
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("W1 Master: ").append(this.masterDir).append("\n");
        builder.append("Device Types: \n");
        for (W1DeviceType deviceType : this.deviceTypeMap.values()) {
            builder.append(" - ").append(Integer.toHexString(deviceType.getDeviceFamilyCode()));
            builder.append(" = ").append(deviceType.getDeviceClass());
            builder.append("\n");
        }
        builder.append("Devices:\n");
        for (W1Device device : this.getDevices()) {
            builder.append(" - ").append(device.getId()).append(": ").append(device.getName());
            builder.append(" = ").append(device.getClass().getName()).append("\n");
        }
        return builder.toString();
    }
}

