/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.file;

import com.pi4j.util.NativeLibraryLoader;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import sun.misc.Cleaner;
import sun.misc.SharedSecrets;

public class LinuxFile
extends RandomAccessFile {
    public static final int wordSize = LinuxFile.getWordSize();
    public static final int localBufferSize = 2048;
    public static final ThreadLocal<ByteBuffer> localDataBuffer = new ThreadLocal();
    public static final ThreadLocal<IntBuffer> localOffsetsBuffer = new ThreadLocal();
    private static final Constructor<?> directByteBufferConstructor;
    private static final Field addressField;
    private static final Field capacityField;
    private static final Field cleanerField;

    public LinuxFile(String name, String mode) throws FileNotFoundException {
        super(name, mode);
    }

    public void ioctl(long command, int value) throws IOException {
        int response = LinuxFile.directIOCTL(this.getFileDescriptor(), command, value);
        if (response < 0) {
            throw new LinuxFileException();
        }
    }

    public void ioctl(long command, ByteBuffer data, IntBuffer offsets) throws IOException {
        ByteBuffer originalData = data;
        if (data == null || offsets == null) {
            throw new NullPointerException("data and offsets required!");
        }
        if (((IntBuffer)offsets).order() != ByteOrder.nativeOrder()) {
            throw new IllegalArgumentException("provided IntBuffer offsets ByteOrder must be native!");
        }
        try {
            Buffer newBuf;
            if (!((ByteBuffer)data).isDirect()) {
                newBuf = this.getDataBuffer(data.limit());
                int pos = data.position();
                ((ByteBuffer)data).rewind();
                ((ByteBuffer)newBuf).clear();
                ((ByteBuffer)newBuf).put((ByteBuffer)data);
                ((ByteBuffer)newBuf).position(pos);
                data = newBuf;
            }
            if (!((IntBuffer)offsets).isDirect()) {
                newBuf = this.getOffsetsBuffer(offsets.remaining());
                ((IntBuffer)newBuf).clear();
                ((IntBuffer)newBuf).put((IntBuffer)offsets);
                ((IntBuffer)newBuf).flip();
                offsets = newBuf;
            }
        }
        catch (BufferOverflowException e) {
            throw new ScratchBufferOverrun();
        }
        if ((offsets.remaining() & 1) != 0) {
            throw new IllegalArgumentException("offset buffer must be even length!");
        }
        for (int i = offsets.position(); i < offsets.limit(); i += 2) {
            int ptrOffset = ((IntBuffer)offsets).get(i);
            int dataOffset = ((IntBuffer)offsets).get(i + 1);
            if (dataOffset >= data.capacity() || dataOffset < 0) {
                throw new IndexOutOfBoundsException("invalid data offset specified in buffer: " + dataOffset);
            }
            if (ptrOffset + wordSize <= data.capacity() && ptrOffset >= 0) continue;
            throw new IndexOutOfBoundsException("invalid pointer offset specified in buffer: " + ptrOffset);
        }
        int response = LinuxFile.directIOCTLStructure(this.getFileDescriptor(), command, (ByteBuffer)data, data.position(), (IntBuffer)offsets, offsets.position(), offsets.remaining());
        if (response < 0) {
            throw new LinuxFileException();
        }
        ((IntBuffer)offsets).position(offsets.limit());
        ((ByteBuffer)data).rewind();
        if (originalData != data) {
            originalData.rewind();
            originalData.put((ByteBuffer)data);
            originalData.rewind();
        }
    }

    private int getFileDescriptor() throws IOException {
        int fd = SharedSecrets.getJavaIOFileDescriptorAccess().get(this.getFD());
        if (fd < 1) {
            throw new IOException("failed to get POSIX file descriptor!");
        }
        return fd;
    }

    private static int getWordSize() {
        String archDataModel = System.getProperty("sun.arch.data.model");
        return "64".equals(archDataModel) ? 8 : 4;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private synchronized IntBuffer getOffsetsBuffer(int size) {
        int byteSize = size * 4;
        IntBuffer buf = localOffsetsBuffer.get();
        if (byteSize > 2048) {
            throw new ScratchBufferOverrun();
        }
        if (buf == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(2048);
            bb.order(ByteOrder.nativeOrder());
            buf = bb.asIntBuffer();
            localOffsetsBuffer.set(buf);
        }
        return buf;
    }

    private synchronized ByteBuffer getDataBuffer(int size) {
        ByteBuffer buf = localDataBuffer.get();
        if (size > 2048) {
            throw new ScratchBufferOverrun();
        }
        if (buf == null) {
            buf = ByteBuffer.allocateDirect(2048);
            localDataBuffer.set(buf);
        }
        return buf;
    }

    public ByteBuffer mmap(int length, MMAPProt prot, MMAPFlags flags, int offset) throws IOException {
        long pointer = LinuxFile.mmap(this.getFileDescriptor(), length, prot.flag, flags.flag, offset);
        if (pointer == -1L) {
            throw new LinuxFileException();
        }
        return this.newMappedByteBuffer(length, pointer, () -> LinuxFile.munmapDirect(pointer, length));
    }

    public static void munmap(ByteBuffer mappedBuffer) throws IOException {
        if (!mappedBuffer.isDirect()) {
            throw new IllegalArgumentException("Must be a mapped direct buffer");
        }
        try {
            long address = addressField.getLong(mappedBuffer);
            int capacity = capacityField.getInt(mappedBuffer);
            if (address == 0L || capacity == 0) {
                return;
            }
            addressField.setLong(mappedBuffer, 0L);
            capacityField.setInt(mappedBuffer, 0);
            mappedBuffer.clear();
            ((Cleaner)cleanerField.get(mappedBuffer)).clean();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalError(e.getMessage());
        }
    }

    private MappedByteBuffer newMappedByteBuffer(int size, long addr, Runnable unmapper) throws IOException {
        MappedByteBuffer dbb;
        try {
            dbb = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Integer(size), new Long(addr), this.getFD(), unmapper);
        }
        catch (InstantiationException e) {
            throw new InternalError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.getMessage());
        }
        return dbb;
    }

    public static native int errno();

    public static native String strerror(int var0);

    protected static native int directIOCTL(int var0, long var1, int var3);

    protected static native long mmap(int var0, int var1, int var2, int var3, int var4);

    protected static native int munmapDirect(long var0, long var2);

    protected static native int directIOCTLStructure(int var0, long var1, ByteBuffer var3, int var4, IntBuffer var5, int var6, int var7);

    static {
        try {
            NativeLibraryLoader.load("libpi4j.so", "pi4j");
            Class<?> dbb = Class.forName("java.nio.DirectByteBuffer");
            addressField = Buffer.class.getDeclaredField("address");
            capacityField = Buffer.class.getDeclaredField("capacity");
            cleanerField = dbb.getDeclaredField("cleaner");
            directByteBufferConstructor = dbb.getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class);
            addressField.setAccessible(true);
            capacityField.setAccessible(true);
            cleanerField.setAccessible(true);
            directByteBufferConstructor.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new InternalError(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public static enum MMAPFlags {
        SHARED(1),
        PRIVATE(2),
        SHARED_PRIVATE(MMAPFlags.SHARED.flag | MMAPFlags.PRIVATE.flag);

        public final int flag;

        private MMAPFlags(int flag) {
            this.flag = flag;
        }
    }

    public static enum MMAPProt {
        NONE(0),
        READ(1),
        WRITE(2),
        EXEC(4),
        RW(MMAPProt.READ.flag | MMAPProt.WRITE.flag),
        RX(MMAPProt.READ.flag | MMAPProt.EXEC.flag),
        RWX(MMAPProt.READ.flag | MMAPProt.WRITE.flag | MMAPProt.EXEC.flag),
        WX(MMAPProt.WRITE.flag | MMAPProt.EXEC.flag);

        public final int flag;

        private MMAPProt(int flag) {
            this.flag = flag;
        }
    }

    public static class LinuxFileException
    extends IOException {
        private static final long serialVersionUID = -2581606746434701394L;
        int code;

        public LinuxFileException() {
            this(LinuxFile.errno());
        }

        LinuxFileException(int code) {
            super(LinuxFile.strerror(code));
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class ScratchBufferOverrun
    extends IllegalArgumentException {
        private static final long serialVersionUID = -418203522640826177L;

        public ScratchBufferOverrun() {
            super("Scratch buffer overrun! Provide direct ByteBuffer for data larger than 2048 bytes");
        }
    }
}

