/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.impl.I2CBusImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class I2CDeviceImpl
implements I2CDevice {
    private I2CBusImpl bus;
    private int deviceAddress;

    @Override
    public int getAddress() {
        return this.deviceAddress;
    }

    public I2CDeviceImpl(I2CBusImpl bus, int address) {
        this.bus = bus;
        this.deviceAddress = address;
    }

    I2CBusImpl getBus() {
        return this.bus;
    }

    @Override
    public void write(byte data) throws IOException {
        this.getBus().writeByteDirect(this, data);
    }

    @Override
    public void write(byte[] data, int offset, int size) throws IOException {
        this.getBus().writeBytesDirect(this, size, offset, data);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(int address, byte data) throws IOException {
        this.getBus().writeByte(this, address, data);
    }

    @Override
    public void write(int address, byte[] data, int offset, int size) throws IOException {
        this.getBus().writeBytes(this, address, size, offset, data);
    }

    @Override
    public void write(int address, byte[] buffer) throws IOException {
        this.write(address, buffer, 0, buffer.length);
    }

    @Override
    public int read() throws IOException {
        return this.getBus().readByteDirect(this);
    }

    @Override
    public int read(byte[] data, int offset, int size) throws IOException {
        return this.getBus().readBytesDirect(this, size, offset, data);
    }

    @Override
    public int read(int address) throws IOException {
        return this.getBus().readByte(this, address);
    }

    @Override
    public int read(int address, byte[] data, int offset, int size) throws IOException {
        return this.getBus().readBytes(this, address, size, offset, data);
    }

    @Override
    public void ioctl(long command, int value) throws IOException {
        this.getBus().ioctl(this, command, value);
    }

    @Override
    public void ioctl(long command, ByteBuffer data, IntBuffer offsets) throws IOException {
        this.getBus().ioctl(this, command, data, offsets);
    }

    @Override
    public int read(byte[] writeData, int writeOffset, int writeSize, byte[] readData, int readOffset, int readSize) throws IOException {
        return this.getBus().writeAndReadBytesDirect(this, writeSize, writeOffset, writeData, readSize, readOffset, readData);
    }

    protected String makeDescription() {
        return "I2CDevice on " + this.bus + " at address 0x" + Integer.toHexString(this.deviceAddress);
    }

    protected String makeDescription(int address) {
        return "I2CDevice on " + this.bus + " at address 0x" + Integer.toHexString(this.deviceAddress) + " to address 0x" + Integer.toHexString(address);
    }
}

