/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.context;

import com.pi4j.common.Describable;
import com.pi4j.common.Descriptor;
import com.pi4j.config.Config;
import com.pi4j.context.ContextConfig;
import com.pi4j.context.ContextProperties;
import com.pi4j.event.InitializedEventProducer;
import com.pi4j.event.ShutdownEventProducer;
import com.pi4j.exception.ShutdownException;
import com.pi4j.internal.IOCreator;
import com.pi4j.internal.ProviderProvider;
import com.pi4j.io.IO;
import com.pi4j.io.IOConfig;
import com.pi4j.io.IOType;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.exception.IOInvalidIDException;
import com.pi4j.io.exception.IONotFoundException;
import com.pi4j.platform.Platform;
import com.pi4j.platform.Platforms;
import com.pi4j.platform.exception.PlatformNotFoundException;
import com.pi4j.provider.Provider;
import com.pi4j.provider.Providers;
import com.pi4j.provider.exception.ProviderInterfaceException;
import com.pi4j.provider.exception.ProviderNotFoundException;
import com.pi4j.registry.Registry;
import com.pi4j.util.PropertiesUtil;
import com.pi4j.util.StringUtil;
import java.util.Map;
import java.util.concurrent.Future;

public interface Context
extends Describable,
IOCreator,
ProviderProvider,
InitializedEventProducer<Context>,
ShutdownEventProducer<Context> {
    public ContextConfig config();

    public ContextProperties properties();

    public Providers providers();

    public Registry registry();

    public Platforms platforms();

    public Context shutdown() throws ShutdownException;

    public Future<Context> asyncShutdown();

    public boolean isShutdown();

    default public <P extends Platform> P platform() {
        return (P)this.platforms().getDefault();
    }

    default public <P extends Platform> P getPlatform() {
        return this.platform();
    }

    default public <P extends Platform> P getDefaultPlatform() {
        return this.platform();
    }

    default public <P extends Platform> P defaultPlatform() {
        return this.platform();
    }

    default public <P extends Platform> P platform(String id) throws PlatformNotFoundException {
        return (P)this.platforms().get(id);
    }

    default public <P extends Platform> P getPlatform(String id) throws PlatformNotFoundException {
        return this.platform(id);
    }

    default public boolean hasPlatform(String id) throws PlatformNotFoundException {
        return this.platforms().exists(id);
    }

    default public <P extends Platform> P platform(Class<P> platformClass) throws PlatformNotFoundException {
        return this.platforms().get(platformClass);
    }

    default public <P extends Platform> P getPlatform(Class<P> platformClass) throws PlatformNotFoundException {
        return this.platform(platformClass);
    }

    default public boolean hasPlatform(Class<? extends Platform> platformClass) throws PlatformNotFoundException {
        return this.platforms().exists(platformClass);
    }

    @Override
    default public <T extends Provider> T provider(String providerId) throws ProviderNotFoundException {
        return this.providers().get(providerId);
    }

    @Override
    default public <T extends Provider> T provider(String providerId, Class<T> providerClass) throws ProviderNotFoundException {
        return this.providers().get(providerId);
    }

    @Override
    default public boolean hasProvider(String providerId) {
        try {
            return this.providers().exists(providerId);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public <T extends Provider> boolean hasProvider(IOType ioType) {
        return this.providers().exists(ioType);
    }

    @Override
    default public <T extends Provider> boolean hasProvider(Class<T> providerClass) {
        return this.providers().exists(providerClass);
    }

    @Override
    default public <T extends Provider> T provider(Class<T> providerClass) throws ProviderNotFoundException, ProviderInterfaceException {
        if (this.platform() != null && this.platform().hasProvider(providerClass)) {
            return this.platform().provider(providerClass);
        }
        if (this.providers().exists(providerClass)) {
            return this.providers().get(providerClass);
        }
        throw new ProviderNotFoundException(providerClass);
    }

    @Override
    default public <T extends Provider> T provider(IOType ioType) throws ProviderNotFoundException {
        if (this.platform() != null && this.platform().hasProvider(ioType)) {
            return this.platform().provider(ioType);
        }
        if (this.providers().exists(ioType)) {
            return this.providers().get(ioType);
        }
        throw new ProviderNotFoundException(ioType);
    }

    @Override
    default public <I extends IO> I create(IOConfig config, IOType ioType) {
        String platformId = config.platform();
        if (StringUtil.isNotNullOrEmpty(platformId)) {
            Platform platform = this.platforms().get(platformId);
            return platform.create(config, ioType);
        }
        String providerId = config.provider();
        if (StringUtil.isNotNullOrEmpty(providerId)) {
            Object provider = this.providers().get(providerId, ioType);
            return (I)provider.create((IOConfig)config);
        }
        if (ioType != null) {
            Object provider = this.provider(ioType);
            return (I)provider.create((IOConfig)config);
        }
        throw new IOException("This IO instance [" + config.id() + "] could not be created because it does not define one of the following: 'PLATFORM', 'PROVIDER', or 'I/O TYPE'.");
    }

    default public <T extends IO> T create(String id) {
        Provider provider = null;
        Map<String, String> inheritedProperties = PropertiesUtil.subProperties(this.properties().all(), id);
        if (inheritedProperties.containsKey("platform")) {
            String platformId = inheritedProperties.get("platform");
            Platform platform = this.platforms().get(platformId);
            return platform.create(id);
        }
        if (inheritedProperties.containsKey("provider")) {
            String providerId = inheritedProperties.get("provider");
            provider = this.providers().get(providerId);
        }
        if (provider == null && inheritedProperties.containsKey("type")) {
            IOType ioType = IOType.parse(inheritedProperties.get("type"));
            provider = this.provider(ioType);
        }
        if (provider == null) {
            throw new IOException("This IO instance [" + id + "] could not be created because it does not define one of the following: 'PLATFORM', 'PROVIDER', or 'I/O TYPE'.");
        }
        Object builder = provider.type().newConfigBuilder(this);
        builder.id(id);
        builder.load(inheritedProperties);
        return (T)provider.create((Config)builder.build());
    }

    default public <T extends IO> T create(String id, IOType ioType) {
        Provider provider = null;
        Map<String, String> inheritedProperties = PropertiesUtil.subProperties(this.properties().all(), id);
        if (inheritedProperties.containsKey("platform")) {
            String platformId = inheritedProperties.get("platform");
            Platform platform = this.platforms().get(platformId);
            return platform.create(id, ioType);
        }
        if (inheritedProperties.containsKey("provider")) {
            String providerId = inheritedProperties.get("provider");
            provider = this.providers().get(providerId, ioType);
            if (!ioType.isType(provider.type())) {
                throw new IOException("This IO instance [" + id + "] could not be created because the resolved provider [" + providerId + "] does not match the required I/O TYPE [" + ioType.name() + "]");
            }
        }
        if ((provider = (Provider)this.provider(ioType)) == null) {
            throw new ProviderNotFoundException(ioType);
        }
        Object builder = provider.type().newConfigBuilder(this);
        builder.id(id);
        builder.load(inheritedProperties);
        return (T)provider.create((Config)builder.build());
    }

    default public boolean hasIO(String id) throws IOInvalidIDException, IONotFoundException {
        return this.registry().exists(id);
    }

    default public <T extends IO> T io(String id) throws IOInvalidIDException, IONotFoundException {
        return this.registry().get(id);
    }

    default public <T extends IO> T io(String id, Class<T> ioClass) throws IOInvalidIDException, IONotFoundException {
        return this.registry().get(id, ioClass);
    }

    default public <T extends IO> T getIO(String id) throws IOInvalidIDException, IONotFoundException {
        return this.io(id);
    }

    default public <T extends IO> T getIO(String id, Class<T> ioClass) throws IOInvalidIDException, IONotFoundException {
        return this.io(id, ioClass);
    }

    @Override
    default public Descriptor describe() {
        Descriptor descriptor = Descriptor.create().category("CONTEXT").name("Runtime Context").type(this.getClass());
        descriptor.add(this.registry().describe());
        descriptor.add(this.platforms().describe());
        descriptor.add(this.providers().describe());
        descriptor.add(this.properties().describe());
        return descriptor;
    }
}

