/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.digital.impl;

import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.PullResistance;
import com.pi4j.io.impl.IOAddressConfigBase;
import com.pi4j.util.StringUtil;
import java.util.Map;

public class DefaultDigitalInputConfig
extends IOAddressConfigBase<DigitalInputConfig>
implements DigitalInputConfig {
    protected PullResistance pullResistance = PullResistance.OFF;
    protected Long debounce = 10000L;

    private DefaultDigitalInputConfig() {
    }

    protected DefaultDigitalInputConfig(Map<String, String> properties) {
        super(properties);
        this.id = StringUtil.setIfNullOrEmpty(this.id, "DIN-" + this.address, true);
        this.name = StringUtil.setIfNullOrEmpty(this.name, "DIN-" + this.address, true);
        this.description = StringUtil.setIfNullOrEmpty(this.description, "DIN-" + this.address, true);
        if (properties.containsKey("pull")) {
            this.pullResistance = PullResistance.parse(properties.get("pull"));
        }
        if (properties.containsKey("debounce")) {
            this.debounce = Long.parseLong(properties.get("debounce"));
        }
    }

    @Override
    public PullResistance pull() {
        return this.pullResistance;
    }

    @Override
    public Long debounce() {
        return this.debounce;
    }
}

