/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.pwm.impl;

import com.pi4j.context.Context;
import com.pi4j.io.impl.IOAddressConfigBuilderBase;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmConfigBuilder;
import com.pi4j.io.pwm.PwmPreset;
import com.pi4j.io.pwm.PwmType;
import com.pi4j.io.pwm.impl.DefaultPwmConfig;
import java.util.ArrayList;
import java.util.List;

public class DefaultPwmConfigBuilder
extends IOAddressConfigBuilderBase<PwmConfigBuilder, PwmConfig>
implements PwmConfigBuilder {
    protected List<PwmPreset> presets = new ArrayList<PwmPreset>();

    protected DefaultPwmConfigBuilder(Context context) {
        super(context);
    }

    public static PwmConfigBuilder newInstance(Context context) {
        return new DefaultPwmConfigBuilder(context);
    }

    @Override
    public PwmConfigBuilder frequency(Integer frequency) {
        this.properties.put("frequency", frequency.toString());
        return this;
    }

    @Override
    public PwmConfigBuilder dutyCycle(Number dutyCycle) {
        float dc = dutyCycle.floatValue();
        if (dc < 0.0f) {
            dc = 0.0f;
        }
        if (dc > 100.0f) {
            dc = 100.0f;
        }
        this.properties.put("duty-cycle", Float.toString(dc));
        return this;
    }

    @Override
    public PwmConfigBuilder pwmType(PwmType pwmType) {
        this.properties.put("pwm-type", pwmType.toString());
        return this;
    }

    @Override
    public PwmConfigBuilder shutdown(Number dutyCycle) {
        float dc = dutyCycle.floatValue();
        if (dc < 0.0f) {
            dc = 0.0f;
        }
        if (dc > 100.0f) {
            dc = 100.0f;
        }
        this.properties.put("shutdown", Float.toString(dc));
        return this;
    }

    @Override
    public PwmConfigBuilder initial(Number dutyCycle) {
        float dc = dutyCycle.floatValue();
        if (dc < 0.0f) {
            dc = 0.0f;
        }
        if (dc > 100.0f) {
            dc = 100.0f;
        }
        this.properties.put("initial", Float.toString(dc));
        return this;
    }

    @Override
    public PwmConfigBuilder preset(PwmPreset ... preset) {
        for (PwmPreset p : preset) {
            this.presets.add(p);
        }
        return this;
    }

    @Override
    public PwmConfig build() {
        DefaultPwmConfig config = new DefaultPwmConfig(this.getResolvedProperties(), this.presets);
        return config;
    }
}

