/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.binding;

import com.pi4j.io.binding.Bindable;
import com.pi4j.io.binding.Binding;
import com.pi4j.io.binding.BindingDelegate;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingManager<SOURCE_TYPE, BINDING_TYPE extends Binding, EVENT_TYPE>
implements Bindable<SOURCE_TYPE, BINDING_TYPE> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SOURCE_TYPE source;
    protected Set<BINDING_TYPE> bindings = new CopyOnWriteArraySet<BINDING_TYPE>();
    protected final BindingDelegate<BINDING_TYPE, EVENT_TYPE> delegate;

    public BindingManager(SOURCE_TYPE source, BindingDelegate<BINDING_TYPE, EVENT_TYPE> delegate) {
        this.source = source;
        this.delegate = delegate;
    }

    public SOURCE_TYPE clear() {
        this.bindings.clear();
        return this.source;
    }

    public SOURCE_TYPE process(EVENT_TYPE event) {
        this.bindings.forEach(binding -> {
            try {
                this.delegate.process((Binding)binding, event);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        });
        return this.source;
    }

    @Override
    public SOURCE_TYPE bind(BINDING_TYPE ... binding) {
        this.bindings.addAll(List.of(binding));
        return this.source;
    }

    @Override
    public SOURCE_TYPE unbind(BINDING_TYPE ... binding) {
        this.bindings.removeAll(List.of(binding));
        return this.source;
    }
}

