/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.pwm;

import com.pi4j.context.Context;
import com.pi4j.io.IO;
import com.pi4j.io.OnOff;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmConfigBuilder;
import com.pi4j.io.pwm.PwmPreset;
import com.pi4j.io.pwm.PwmProvider;
import com.pi4j.io.pwm.PwmType;
import java.util.Map;

public interface Pwm
extends IO<Pwm, PwmConfig, PwmProvider>,
OnOff<Pwm> {
    public static PwmConfigBuilder newConfigBuilder(Context context) {
        return PwmConfigBuilder.newInstance(context);
    }

    default public int getAddress() {
        return ((PwmConfig)this.config()).address();
    }

    default public int address() {
        return this.getAddress();
    }

    @Override
    public boolean isOn();

    @Override
    default public boolean isOff() {
        return !this.isOn();
    }

    @Override
    public Pwm on() throws IOException;

    @Override
    public Pwm off() throws IOException;

    default public PwmType pwmType() {
        return ((PwmConfig)this.config()).getPwmType();
    }

    default public PwmType getPwmType() {
        return this.pwmType();
    }

    default public Pwm on(Number dutyCycle) throws IOException {
        if (dutyCycle.floatValue() > 0.0f) {
            this.setDutyCycle(Float.valueOf(dutyCycle.floatValue()));
            return this.on();
        }
        return this.off();
    }

    default public Pwm on(Number dutyCycle, int frequency) throws IOException {
        if (dutyCycle.floatValue() > 0.0f && frequency > 0) {
            this.setDutyCycle(Float.valueOf(dutyCycle.floatValue()));
            this.setFrequency(frequency);
            return this.on();
        }
        return this.off();
    }

    public float getDutyCycle() throws IOException;

    default public float dutyCycle() throws IOException {
        return this.getDutyCycle();
    }

    public void setDutyCycle(Number var1) throws IOException;

    default public Pwm dutyCycle(Number dutyCycle) throws IOException {
        this.setDutyCycle(dutyCycle);
        return this;
    }

    public int getFrequency() throws IOException;

    default public int frequency() throws IOException {
        return this.getFrequency();
    }

    public int getActualFrequency() throws IOException;

    default public int actualFrequency() throws IOException {
        return this.getActualFrequency();
    }

    public void setFrequency(int var1) throws IOException;

    default public Pwm frequency(int frequency) throws IOException {
        this.setFrequency(frequency);
        return this;
    }

    public Map<String, PwmPreset> getPresets();

    default public Map<String, PwmPreset> presets() {
        return this.getPresets();
    }

    public PwmPreset getPreset(String var1);

    default public PwmPreset preset(String name) {
        return this.getPreset(name);
    }

    public PwmPreset deletePreset(String var1);

    public Pwm addPreset(PwmPreset var1);

    public Pwm applyPreset(String var1) throws IOException;
}

