/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.pwm;

import java.util.EnumSet;

public enum PwmType {
    SOFTWARE(0, "software"),
    HARDWARE(1, "hardware");

    private final int value;
    private final String name;

    private PwmType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toUpperCase();
    }

    public static EnumSet<PwmType> all() {
        return EnumSet.allOf(PwmType.class);
    }

    public static PwmType parse(String pull) {
        if (pull.equalsIgnoreCase("0")) {
            return SOFTWARE;
        }
        if (pull.equalsIgnoreCase("1")) {
            return HARDWARE;
        }
        if (pull.toLowerCase().startsWith("h")) {
            return HARDWARE;
        }
        if (pull.toLowerCase().startsWith("s")) {
            return SOFTWARE;
        }
        return SOFTWARE;
    }
}

