/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.pwm.impl;

import com.pi4j.io.gpio.digital.PullResistance;
import com.pi4j.io.impl.IOAddressConfigBase;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmPreset;
import com.pi4j.io.pwm.PwmType;
import com.pi4j.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DefaultPwmConfig
extends IOAddressConfigBase<PwmConfig>
implements PwmConfig {
    protected Float dutyCycle = null;
    protected Integer frequency = null;
    protected PwmType pwmType = PwmType.SOFTWARE;
    protected Float shutdownValue = null;
    protected Float initialValue = null;
    protected List<PwmPreset> presets = new ArrayList<PwmPreset>();
    protected PullResistance pullResistance = PullResistance.OFF;

    private DefaultPwmConfig() {
    }

    protected DefaultPwmConfig(Map<String, String> properties, Collection<PwmPreset> presets) {
        this(properties);
        this.presets.addAll(presets);
    }

    protected DefaultPwmConfig(Map<String, String> properties) {
        super(properties);
        this.id = StringUtil.setIfNullOrEmpty(this.id, "PWM-" + this.address, true);
        this.name = StringUtil.setIfNullOrEmpty(this.name, "PWM-" + this.address, true);
        this.description = StringUtil.setIfNullOrEmpty(this.description, "PWM-" + this.address, true);
        if (properties.containsKey("duty-cycle")) {
            this.dutyCycle = Float.valueOf(Float.parseFloat(properties.get("duty-cycle")));
        }
        if (properties.containsKey("frequency")) {
            this.frequency = Integer.parseInt(properties.get("frequency"));
        }
        if (properties.containsKey("pwm-type")) {
            this.pwmType = PwmType.parse(properties.get("pwm-type"));
        }
        if (properties.containsKey("initial")) {
            this.initialValue = Float.valueOf(Float.parseFloat(properties.get("initial")));
        }
        if (properties.containsKey("shutdown")) {
            this.shutdownValue = Float.valueOf(Float.parseFloat(properties.get("shutdown")));
        }
        if (this.dutyCycle != null && this.dutyCycle.floatValue() > 100.0f) {
            this.dutyCycle = Float.valueOf(100.0f);
        }
        if (this.dutyCycle != null && this.dutyCycle.floatValue() < 0.0f) {
            this.dutyCycle = Float.valueOf(0.0f);
        }
    }

    @Override
    public Float dutyCycle() {
        return this.dutyCycle;
    }

    @Override
    public Integer frequency() {
        return this.frequency;
    }

    @Override
    public PwmType pwmType() {
        return this.pwmType;
    }

    @Override
    public Float shutdownValue() {
        return this.shutdownValue;
    }

    @Override
    public PwmConfig shutdownValue(Number dutyCycle) {
        float dc = dutyCycle.floatValue();
        if (dc < 0.0f) {
            dc = 0.0f;
        }
        if (dc > 100.0f) {
            dc = 100.0f;
        }
        this.shutdownValue = Float.valueOf(dc);
        return this;
    }

    @Override
    public Float initialValue() {
        return this.initialValue;
    }

    @Override
    public Collection<PwmPreset> presets() {
        return this.presets;
    }
}

