/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.spi;

import com.pi4j.context.Context;
import com.pi4j.io.IO;
import com.pi4j.io.IODataReader;
import com.pi4j.io.IODataWriter;
import com.pi4j.io.spi.SpiConfig;
import com.pi4j.io.spi.SpiConfigBuilder;
import com.pi4j.io.spi.SpiMode;
import com.pi4j.io.spi.SpiProvider;
import java.nio.ByteBuffer;

public interface Spi
extends IO<Spi, SpiConfig, SpiProvider>,
AutoCloseable,
IODataWriter,
IODataReader {
    public static final SpiMode DEFAULT_MODE = SpiMode.MODE_0;
    public static final int DEFAULT_BAUD = 1000000;

    public static SpiConfigBuilder newConfigBuilder(Context context) {
        return SpiConfigBuilder.newInstance(context);
    }

    public boolean isOpen();

    public void open();

    @Override
    public void close();

    default public int transferByte(int handle, byte value) {
        byte[] temp = new byte[]{value};
        int result = this.transfer(temp);
        if (result <= 0) {
            return result;
        }
        return Byte.toUnsignedInt(temp[0]);
    }

    public int transfer(byte[] var1, int var2, byte[] var3, int var4, int var5);

    default public int transfer(byte[] write, byte[] read, int numberOfBytes) {
        return this.transfer(write, 0, read, 0, numberOfBytes);
    }

    default public int transfer(byte[] write, byte[] read) {
        return this.transfer(write, 0, read, 0, write.length);
    }

    default public int transfer(byte[] buffer, int offset, int length) {
        return this.transfer(buffer, offset, buffer, offset, length);
    }

    default public int transfer(byte[] buffer, int length) {
        return this.transfer(buffer, 0, length);
    }

    default public int transfer(byte[] buffer) {
        return this.transfer(buffer, 0, buffer.length);
    }

    default public int transfer(ByteBuffer write, int writeOffset, ByteBuffer read, int readOffset, int numberOfBytes) {
        if (numberOfBytes > write.capacity() - writeOffset) {
            numberOfBytes = write.capacity() - writeOffset;
        }
        byte[] temp = new byte[numberOfBytes];
        int actualLength = this.transfer(write.array(), 0, temp, 0, numberOfBytes);
        if (actualLength < 0) {
            return actualLength;
        }
        if (actualLength < numberOfBytes) {
            numberOfBytes = actualLength;
        }
        read.position(readOffset);
        read.put(temp, 0, numberOfBytes);
        return numberOfBytes;
    }

    default public int transfer(ByteBuffer write, ByteBuffer read, int numberOfBytes) {
        if (write.position() == write.limit()) {
            write.flip();
        }
        if (read.position() == read.limit()) {
            read.rewind();
        }
        if (numberOfBytes > write.remaining()) {
            numberOfBytes = write.remaining();
        }
        return this.transfer(write, write.position(), read, read.position(), numberOfBytes);
    }

    default public int transfer(ByteBuffer buffer, int offset, int length) {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        byte[] temp = new byte[length];
        int actualLength = this.transfer(buffer.array(), 0, temp, 0, length);
        if (actualLength < 0) {
            return actualLength;
        }
        if (actualLength < length) {
            length = actualLength;
        }
        buffer.position(offset);
        buffer.put(temp, 0, length);
        return length;
    }
}

