/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io;

import com.pi4j.context.Context;
import com.pi4j.exception.Pi4JException;
import com.pi4j.io.IO;
import com.pi4j.io.IOConfig;
import com.pi4j.io.IOConfigBuilder;
import com.pi4j.io.gpio.analog.AnalogInput;
import com.pi4j.io.gpio.analog.AnalogInputConfig;
import com.pi4j.io.gpio.analog.AnalogInputConfigBuilder;
import com.pi4j.io.gpio.analog.AnalogInputProvider;
import com.pi4j.io.gpio.analog.AnalogOutput;
import com.pi4j.io.gpio.analog.AnalogOutputConfig;
import com.pi4j.io.gpio.analog.AnalogOutputConfigBuilder;
import com.pi4j.io.gpio.analog.AnalogOutputProvider;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalInputProvider;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmConfigBuilder;
import com.pi4j.io.pwm.PwmProvider;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.SerialConfigBuilder;
import com.pi4j.io.serial.SerialProvider;
import com.pi4j.io.spi.Spi;
import com.pi4j.io.spi.SpiProvider;
import com.pi4j.provider.Provider;
import java.lang.reflect.Method;

public enum IOType {
    ANALOG_INPUT(AnalogInputProvider.class, AnalogInput.class, AnalogInputConfig.class, AnalogInputConfigBuilder.class),
    ANALOG_OUTPUT(AnalogOutputProvider.class, AnalogOutput.class, AnalogOutputConfig.class, AnalogOutputConfigBuilder.class),
    DIGITAL_INPUT(DigitalInputProvider.class, DigitalInput.class, DigitalInputConfig.class, DigitalInputConfigBuilder.class),
    DIGITAL_OUTPUT(DigitalOutputProvider.class, DigitalOutput.class, DigitalOutputConfig.class, DigitalOutputConfigBuilder.class),
    PWM(PwmProvider.class, Pwm.class, PwmConfig.class, PwmConfigBuilder.class),
    I2C(I2CProvider.class, I2C.class, I2CConfig.class, I2CConfigBuilder.class),
    SPI(SpiProvider.class, Spi.class, I2CConfig.class, I2CConfigBuilder.class),
    SERIAL(SerialProvider.class, Serial.class, SerialConfig.class, SerialConfigBuilder.class);

    private Class<? extends Provider> providerClass;
    private Class<? extends IO> ioClass;
    private Class<? extends IOConfig> configClass;
    private Class<? extends IOConfigBuilder> configBuilderClass;

    private IOType(Class<? extends Provider> providerClass, Class<? extends IO> ioClass, Class<? extends IOConfig> configClass, Class<? extends IOConfigBuilder> configBuilderClass) {
        this.providerClass = providerClass;
        this.ioClass = ioClass;
        this.configClass = configClass;
        this.configBuilderClass = configBuilderClass;
    }

    public Class<? extends Provider> getProviderClass() {
        return this.providerClass;
    }

    public Class<? extends IO> getIOClass() {
        return this.ioClass;
    }

    public Class<? extends IOConfig> getConfigClass() {
        return this.configClass;
    }

    public Class<? extends IOConfigBuilder> getConfigBuilderClass() {
        return this.configBuilderClass;
    }

    public <CB extends IOConfigBuilder> CB newConfigBuilder(Context context) {
        try {
            Method newInstance = this.getConfigBuilderClass().getMethod("newInstance", Context.class);
            return (CB)((IOConfigBuilder)newInstance.invoke(null, context));
        }
        catch (Exception e) {
            throw new Pi4JException(e);
        }
    }

    public boolean isType(IOType type) {
        return type == this;
    }

    public static Class<? extends IO> getIOClass(IOType type) {
        for (IOType typeInstance : IOType.values()) {
            if (!typeInstance.equals((Object)type)) continue;
            return typeInstance.getIOClass();
        }
        return null;
    }

    public static Class<? extends Provider> getProviderClass(IOType type) {
        for (IOType typeInstance : IOType.values()) {
            if (!typeInstance.equals((Object)type)) continue;
            return typeInstance.getProviderClass();
        }
        return null;
    }

    public static Class<? extends IOConfig> getConfigClass(IOType type) {
        for (IOType typeInstance : IOType.values()) {
            if (!typeInstance.equals((Object)type)) continue;
            return typeInstance.getConfigClass();
        }
        return null;
    }

    public static IOType getByProviderClass(String name) {
        for (IOType type : IOType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static IOType getByIO(Provider provider) {
        return provider.type();
    }

    public static IOType getByProviderClass(Class<? extends Provider> providerClass) {
        for (IOType type : IOType.values()) {
            if (!type.getProviderClass().isAssignableFrom(providerClass)) continue;
            return type;
        }
        return null;
    }

    public static IOType getByIO(IO io) {
        return io.type();
    }

    public static IOType getByIOClass(Class<? extends IO> ioClass) {
        for (IOType type : IOType.values()) {
            if (!type.getIOClass().isAssignableFrom(ioClass)) continue;
            return type;
        }
        return null;
    }

    public static IOType getByConfigClass(Class<? extends IOConfig> configClass) {
        for (IOType type : IOType.values()) {
            if (!type.getConfigClass().isAssignableFrom(configClass)) continue;
            return type;
        }
        return null;
    }

    public static IOType parse(String ioType) {
        try {
            IOType iot = IOType.valueOf(ioType);
            if (iot != null) {
                return iot;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ioType = ioType.toLowerCase();
        if (ioType.startsWith("analog.i")) {
            return ANALOG_INPUT;
        }
        if (ioType.startsWith("analog-i")) {
            return ANALOG_INPUT;
        }
        if (ioType.startsWith("analog_i")) {
            return ANALOG_INPUT;
        }
        if (ioType.startsWith("analog i")) {
            return ANALOG_INPUT;
        }
        if (ioType.equalsIgnoreCase("ain")) {
            return ANALOG_INPUT;
        }
        if (ioType.startsWith("analog.o")) {
            return ANALOG_OUTPUT;
        }
        if (ioType.startsWith("analog-o")) {
            return ANALOG_OUTPUT;
        }
        if (ioType.startsWith("analog_o")) {
            return ANALOG_OUTPUT;
        }
        if (ioType.startsWith("analog o")) {
            return ANALOG_OUTPUT;
        }
        if (ioType.equalsIgnoreCase("aout")) {
            return ANALOG_OUTPUT;
        }
        if (ioType.startsWith("digital.i")) {
            return DIGITAL_INPUT;
        }
        if (ioType.startsWith("digital-i")) {
            return DIGITAL_INPUT;
        }
        if (ioType.startsWith("digital_i")) {
            return DIGITAL_INPUT;
        }
        if (ioType.startsWith("digital i")) {
            return DIGITAL_INPUT;
        }
        if (ioType.equalsIgnoreCase("din")) {
            return DIGITAL_INPUT;
        }
        if (ioType.startsWith("digital.o")) {
            return DIGITAL_OUTPUT;
        }
        if (ioType.startsWith("digital-o")) {
            return DIGITAL_OUTPUT;
        }
        if (ioType.startsWith("digital_o")) {
            return DIGITAL_OUTPUT;
        }
        if (ioType.startsWith("digital o")) {
            return DIGITAL_OUTPUT;
        }
        if (ioType.equalsIgnoreCase("dout")) {
            return DIGITAL_OUTPUT;
        }
        if (ioType.equalsIgnoreCase("pwm")) {
            return PWM;
        }
        if (ioType.equalsIgnoreCase("p.w.m")) {
            return PWM;
        }
        if (ioType.equalsIgnoreCase("p-w-m")) {
            return PWM;
        }
        if (ioType.equalsIgnoreCase("p_w_m")) {
            return PWM;
        }
        if (ioType.startsWith("pulse.width")) {
            return PWM;
        }
        if (ioType.startsWith("pulse-width")) {
            return PWM;
        }
        if (ioType.startsWith("pulse_width")) {
            return PWM;
        }
        if (ioType.startsWith("pulse width")) {
            return PWM;
        }
        if (ioType.equalsIgnoreCase("i\u00b2c")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("i2c")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("i.2.c")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("i-2-c")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("i_2_c")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("i 2 c")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("inter.integrated.circuit")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("inter-integrated-circuit")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("inter_integrated_circuit")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("inter integrated circuit")) {
            return I2C;
        }
        if (ioType.equalsIgnoreCase("spi")) {
            return SPI;
        }
        if (ioType.equalsIgnoreCase("serial.peripheral.interface")) {
            return SPI;
        }
        if (ioType.equalsIgnoreCase("serial-peripheral-interface")) {
            return SPI;
        }
        if (ioType.equalsIgnoreCase("serial_peripheral_interface")) {
            return SPI;
        }
        if (ioType.equalsIgnoreCase("serial peripheral interface")) {
            return SPI;
        }
        if (ioType.equalsIgnoreCase("serial")) {
            return SERIAL;
        }
        if (ioType.equalsIgnoreCase("uart")) {
            return SERIAL;
        }
        if (ioType.equalsIgnoreCase("rs232")) {
            return SERIAL;
        }
        throw new IllegalArgumentException("Unknown IO TYPE: " + ioType);
    }
}

