/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.gpio.digital.DigitalBase;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.DigitalStateChangeEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class DigitalOutputBase
extends DigitalBase<DigitalOutput, DigitalOutputConfig, DigitalOutputProvider>
implements DigitalOutput {
    protected DigitalState state = DigitalState.UNKNOWN;

    public DigitalOutputBase(DigitalOutputProvider provider, DigitalOutputConfig config) {
        super(provider, config);
    }

    @Override
    public DigitalOutput initialize(Context context) throws InitializeException {
        super.initialize(context);
        if (((DigitalOutputConfig)this.config()).initialState() != null) {
            try {
                this.state(((DigitalOutputConfig)this.config()).initialState());
            }
            catch (IOException e) {
                throw new InitializeException(e);
            }
        }
        return this;
    }

    @Override
    public DigitalOutput state(DigitalState state) throws IOException {
        if (!this.equals(state)) {
            this.state = state;
            this.dispatch(new DigitalStateChangeEvent<DigitalOutputBase>(this, this.state));
        }
        return this;
    }

    @Override
    public DigitalOutput pulse(int interval, TimeUnit unit, DigitalState state, Callable<Void> callback) throws IOException {
        int millis = 0;
        if (interval <= 0) {
            throw new IllegalArgumentException("A time interval of zero or less is not supported.");
        }
        if (unit == TimeUnit.MICROSECONDS) {
            throw new IllegalArgumentException("TimeUnit.MICROSECONDS is not supported.");
        }
        if (unit == TimeUnit.DAYS) {
            throw new IllegalArgumentException("TimeUnit.DAYS is not supported.");
        }
        if (unit == TimeUnit.MILLISECONDS) {
            millis = interval;
        } else if (unit == TimeUnit.SECONDS) {
            millis = interval * 1000;
        } else if (unit == TimeUnit.MINUTES) {
            millis = interval * 60000;
        } else if (unit == TimeUnit.HOURS) {
            millis = interval * 360000;
        } else {
            throw new IllegalArgumentException("TimeUnit provided is not supported.");
        }
        this.state(state);
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Pulse blocking thread interrupted.", e);
        }
        this.state(DigitalState.getInverseState(state));
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    @Override
    public Future<?> pulseAsync(int interval, TimeUnit unit, DigitalState state, Callable<Void> callback) {
        throw new UnsupportedOperationException("PULSE ASYNC has not yet been implemented!");
    }

    @Override
    public DigitalOutput blink(int delay, int duration, TimeUnit unit, DigitalState state, Callable<Void> callback) {
        throw new UnsupportedOperationException("BLINK has not yet been implemented!");
    }

    @Override
    public Future<?> blinkAsync(int delay, int duration, TimeUnit unit, DigitalState state, Callable<Void> callback) {
        throw new UnsupportedOperationException("BLINK ASYNC has not yet been implemented!");
    }

    @Override
    public DigitalState state() {
        return this.state;
    }

    @Override
    public DigitalOutput shutdown(Context context) throws ShutdownException {
        if (((DigitalOutputConfig)this.config()).shutdownState() != null && ((DigitalOutputConfig)this.config()).shutdownState() != DigitalState.UNKNOWN) {
            try {
                this.state(((DigitalOutputConfig)this.config()).shutdownState());
            }
            catch (IOException e) {
                throw new ShutdownException(e);
            }
        }
        return (DigitalOutput)super.shutdown(context);
    }

    @Override
    public DigitalOutput on() throws IOException {
        DigitalState onState = DigitalState.HIGH;
        if (((DigitalOutputConfig)this.config()).onState() != null) {
            onState = ((DigitalOutputConfig)this.config()).onState();
        }
        return this.state(onState);
    }

    @Override
    public DigitalOutput off() throws IOException {
        DigitalState offState = DigitalState.LOW;
        if (((DigitalOutputConfig)this.config()).onState() != null) {
            offState = DigitalState.getInverseState(((DigitalOutputConfig)this.config()).onState());
        }
        return this.state(offState);
    }
}

