/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c;

import com.pi4j.io.exception.IOReadException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public interface I2CRegisterDataReader {
    public int readRegister(int var1);

    public int readRegister(int var1, byte[] var2, int var3, int var4);

    default public int readRegister(int register, byte[] buffer, int length) {
        return this.readRegister(register, buffer, 0, length);
    }

    default public int readRegister(int register, byte[] buffer) {
        return this.readRegister(register, buffer, buffer.length);
    }

    default public int readRegister(int register, ByteBuffer buffer, int offset, int length) {
        int actualLength;
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        if ((actualLength = this.readRegister(register, buffer.array(), offset, length)) < 0) {
            return actualLength;
        }
        buffer.position(offset + actualLength);
        return actualLength;
    }

    default public int readRegister(int register, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.readRegister(register, buffer, buffer.position(), length);
    }

    default public int readRegister(int register, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.readRegister(register, buffer, buffer.position(), buffer.remaining());
    }

    default public int readRegister(int register, Charset charset, char[] buffer, int offset, int length) {
        int maxBytes = (int)charset.newDecoder().maxCharsPerByte() * length;
        byte[] rx = new byte[maxBytes];
        int actualLength = this.readRegister(register, rx, maxBytes);
        if (actualLength < 0) {
            return actualLength;
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(rx));
        if (actualLength < length) {
            length = actualLength;
        }
        if (length > buffer.length - offset) {
            length = buffer.length - offset;
        }
        cb.get(buffer, offset, length);
        return length;
    }

    default public int readRegister(int register, Charset charset, char[] buffer, int length) {
        return this.readRegister(register, buffer, 0, length);
    }

    default public int readRegister(int register, Charset charset, char[] buffer) {
        return this.readRegister(register, buffer, buffer.length);
    }

    default public int readRegister(int register, char[] buffer, int offset, int length) {
        return this.readRegister(register, StandardCharsets.US_ASCII, buffer, offset, length);
    }

    default public int readRegister(int register, char[] buffer, int length) {
        return this.readRegister(register, StandardCharsets.US_ASCII, buffer, length);
    }

    default public int readRegister(int register, char[] buffer) {
        return this.readRegister(register, StandardCharsets.US_ASCII, buffer, buffer.length);
    }

    default public int readRegister(int register, Charset charset, CharBuffer buffer, int offset, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Invalid read request; length must be greater than zero.");
        }
        int maxBytes = (int)charset.newDecoder().maxCharsPerByte() * length;
        byte[] rx = new byte[maxBytes];
        int actualLength = this.readRegister(register, rx, maxBytes);
        if (actualLength < 0) {
            return actualLength;
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(rx));
        if (actualLength < length) {
            length = actualLength;
        }
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        buffer.position(offset);
        buffer.put(cb.array(), 0, length);
        return length;
    }

    default public int readRegister(int register, Charset charset, CharBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.readRegister(register, buffer, buffer.position(), length);
    }

    default public int readRegister(int register, Charset charset, CharBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.readRegister(register, buffer, buffer.position(), buffer.remaining());
    }

    default public int readRegister(int register, CharBuffer buffer, int offset, int length) {
        return this.readRegister(register, StandardCharsets.US_ASCII, buffer, offset, length);
    }

    default public int readRegister(int register, CharBuffer buffer, int length) {
        return this.readRegister(register, StandardCharsets.US_ASCII, buffer, length);
    }

    default public int readRegister(int register, CharBuffer buffer) {
        return this.readRegister(register, StandardCharsets.US_ASCII, buffer);
    }

    default public byte readRegisterByte(int register) {
        int actual = this.readRegister(register);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        return (byte)actual;
    }

    default public int readRegisterWord(int register) {
        byte[] buffer = new byte[2];
        int actual = this.readRegister(register, buffer);
        if (actual < 2) {
            throw new IOReadException(actual);
        }
        return (buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF;
    }

    default public byte[] readRegisterNBytes(int register, int offset, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length <= 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (length < offset) {
            throw new IllegalArgumentException("length < offset");
        }
        int maxLength = offset + length;
        byte[] temp = new byte[maxLength];
        int actual = this.readRegister(register, temp, offset, maxLength);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        return Arrays.copyOf(temp, actual);
    }

    default public byte[] readRegisterNBytes(int register, int length) {
        return this.readRegisterNBytes(register, 0, length);
    }

    default public ByteBuffer readRegisterByteBuffer(int register, int offset, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length <= 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (length < offset) {
            throw new IllegalArgumentException("length < offset");
        }
        byte[] temp = new byte[length];
        int actual = this.readRegister(register, temp, offset, length);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        return ByteBuffer.wrap(temp, 0, actual);
    }

    default public ByteBuffer readRegisterByteBuffer(int register, int length) {
        byte[] temp = new byte[length];
        int actual = this.readRegister(register, temp, 0, length);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        return ByteBuffer.wrap(temp, 0, actual);
    }

    default public char[] readRegisterCharArray(int register, Charset charset, int offset, int numberOfBytes) throws IOReadException {
        byte[] temp = new byte[numberOfBytes];
        int actual = this.readRegister(register, temp, offset, numberOfBytes);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(temp, 0, actual));
        return cb.array();
    }

    default public char[] readRegisterCharArray(int register, Charset charset, int numberOfBytes) throws IOReadException {
        return this.readRegisterCharArray(register, charset, 0, numberOfBytes);
    }

    default public char[] readRegisterCharArray(int register, int offset, int numberOfBytes) throws IOReadException {
        return this.readRegisterCharArray(register, StandardCharsets.US_ASCII, offset, numberOfBytes);
    }

    default public char[] readRegisterCharArray(int register, int numberOfBytes) throws IOReadException {
        return this.readRegisterCharArray(register, 0, numberOfBytes);
    }

    default public CharBuffer readRegisterCharBuffer(int register, Charset charset, int offset, int numberOfBytes) throws IOReadException {
        byte[] temp = new byte[numberOfBytes];
        int actual = this.readRegister(register, temp, offset, numberOfBytes);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(temp, 0, actual));
        return cb.flip();
    }

    default public CharBuffer readRegisterCharBuffer(int register, Charset charset, int numberOfBytes) throws IOReadException {
        return this.readRegisterCharBuffer(register, charset, 0, numberOfBytes);
    }

    default public CharBuffer readRegisterCharBuffer(int register, int offset, int numberOfBytes) throws IOReadException {
        return this.readRegisterCharBuffer(register, StandardCharsets.US_ASCII, offset, numberOfBytes);
    }

    default public CharBuffer readRegisterCharBuffer(int register, int numberOfBytes) throws IOReadException {
        return this.readRegisterCharBuffer(register, 0, numberOfBytes);
    }

    default public String readRegisterString(int register, Charset charset, int offset, int numberOfBytes) throws IOReadException {
        byte[] temp = new byte[numberOfBytes];
        int actual = this.readRegister(register, temp, 0, numberOfBytes);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        return new String(temp, 0, actual, charset);
    }

    default public String readRegisterString(int register, Charset charset, int numberOfBytes) {
        return this.readRegisterString(register, charset, 0, numberOfBytes);
    }

    default public String readRegisterString(int register, int offset, int numberOfBytes) {
        return this.readRegisterString(register, StandardCharsets.US_ASCII, offset, numberOfBytes);
    }

    default public String readRegisterString(int register, int numberOfBytes) throws IOReadException {
        return this.readRegisterString(register, 0, numberOfBytes);
    }
}

