/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.config.exception.ConfigMissingRequiredKeyException;
import com.pi4j.io.gpio.digital.PullResistance;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.impl.IOConfigBase;
import com.pi4j.util.StringUtil;
import java.util.Map;

public class DefaultI2CConfig
extends IOConfigBase<I2CConfig>
implements I2CConfig {
    protected Integer bus = null;
    protected Integer device = null;
    protected PullResistance pullResistance = PullResistance.OFF;

    private DefaultI2CConfig() {
    }

    protected DefaultI2CConfig(Map<String, String> properties) {
        super(properties);
        if (!properties.containsKey("bus")) {
            throw new ConfigMissingRequiredKeyException("bus");
        }
        this.bus = Integer.parseInt(properties.get("bus"));
        if (!properties.containsKey("device")) {
            throw new ConfigMissingRequiredKeyException("device");
        }
        this.device = Integer.parseInt(properties.get("device"));
        this.id = StringUtil.setIfNullOrEmpty(this.id, "I2C-" + this.bus() + "." + this.device(), true);
        this.name = StringUtil.setIfNullOrEmpty(this.name, "I2C-" + this.bus() + "." + this.device(), true);
        this.description = StringUtil.setIfNullOrEmpty(this.description, "I2C-" + this.bus() + "." + this.device(), true);
    }

    @Override
    public Integer bus() {
        return this.bus;
    }

    @Override
    public Integer device() {
        return this.device;
    }
}

