/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.platform;

import com.pi4j.config.Config;
import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.extension.ExtensionBase;
import com.pi4j.io.IO;
import com.pi4j.io.IOConfig;
import com.pi4j.io.IOType;
import com.pi4j.io.exception.IOException;
import com.pi4j.platform.Platform;
import com.pi4j.provider.Provider;
import com.pi4j.provider.exception.ProviderException;
import com.pi4j.provider.exception.ProviderInterfaceException;
import com.pi4j.provider.exception.ProviderNotFoundException;
import com.pi4j.provider.impl.ProviderProxyHandler;
import com.pi4j.util.PropertiesUtil;
import com.pi4j.util.StringUtil;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlatformBase<PLATFORM extends Platform>
extends ExtensionBase<Platform>
implements Platform {
    protected Context context = null;
    protected Map<IOType, Provider> providers = new ConcurrentHashMap<IOType, Provider>();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public PlatformBase() {
    }

    public PlatformBase(String id) {
        super(id);
    }

    public PlatformBase(String id, String name) {
        super(id, name);
    }

    public PlatformBase(String id, String name, String description) {
        super(id, name, description);
    }

    @Override
    public Map<IOType, Provider> providers() {
        return Collections.unmodifiableMap(this.providers);
    }

    @Override
    public <T extends Provider> T provider(Class<T> providerClass) throws ProviderNotFoundException, ProviderInterfaceException {
        if (!providerClass.isInterface()) {
            this.logger.warn("Provider type [" + providerClass.getName() + "] requested; this is not an 'Interface' and may not return a valid provider or may not be able to cast to the concrete class.");
        }
        for (Provider p : this.providers.values()) {
            ProviderProxyHandler pp;
            if (providerClass.isAssignableFrom(p.getClass())) {
                return (T)p;
            }
            if (!Proxy.isProxyClass(p.getClass()) || !Proxy.getInvocationHandler(p).getClass().isAssignableFrom(ProviderProxyHandler.class) || !providerClass.isAssignableFrom((pp = (ProviderProxyHandler)Proxy.getInvocationHandler(p)).provider().getClass())) continue;
            return (T)p;
        }
        if (providerClass.isInterface()) {
            throw new ProviderNotFoundException(providerClass);
        }
        throw new ProviderInterfaceException(providerClass);
    }

    @Override
    public <I extends IO> I create(IOConfig config, IOType ioType) {
        String providerId = config.provider();
        if (StringUtil.isNotNullOrEmpty(providerId)) {
            Object provider = this.provider(providerId);
            return (I)provider.create((IOConfig)config);
        }
        if (this.hasProvider(ioType)) {
            Object provider = this.provider(ioType);
            if (provider == null) {
                throw new ProviderNotFoundException(ioType);
            }
            return (I)provider.create((IOConfig)config);
        }
        throw new ProviderNotFoundException(ioType);
    }

    @Override
    public <T extends IO> T create(String id) {
        Provider provider = null;
        if (this.context == null) {
            throw new IllegalStateException("Unable to create IO instance; this platform has not been 'initialized()' with a Pi4J context.");
        }
        Map<String, String> inheritedProperties = PropertiesUtil.subProperties(this.context.properties().all(), id);
        if (inheritedProperties.containsKey("provider")) {
            String providerId = inheritedProperties.get("provider");
            provider = this.provider(providerId);
        }
        if (provider == null && inheritedProperties.containsKey("type")) {
            IOType ioType = IOType.parse(inheritedProperties.get("type"));
            provider = this.provider(ioType);
        }
        if (provider == null) {
            throw new IOException("This IO instance [" + id + "] could not be created because it does not define one of the following: 'PROVIDER', or 'I/O TYPE'.");
        }
        Object builder = provider.type().newConfigBuilder(this.context);
        builder.id(id);
        builder.load(inheritedProperties);
        return (T)provider.create((Config)builder.build());
    }

    @Override
    public <T extends IO> T create(String id, IOType ioType) {
        String providerId;
        Provider provider = null;
        if (this.context == null) {
            throw new IllegalStateException("Unable to create IO instance; this platform has not been 'initialized()' with a Pi4J context.");
        }
        Map<String, String> inheritedProperties = PropertiesUtil.subProperties(this.context.properties().all(), id);
        if (inheritedProperties.containsKey("provider") && !ioType.isType((provider = this.provider(providerId = inheritedProperties.get("provider"))).type())) {
            throw new IOException("This IO instance [" + id + "] could not be created because the resolved provider [" + providerId + "] does not match the required I/O TYPE [" + ioType.name() + "]");
        }
        provider = (Provider)this.provider(ioType);
        if (provider == null) {
            throw new ProviderNotFoundException(ioType);
        }
        Object builder = provider.type().newConfigBuilder(this.context);
        builder.id(id);
        builder.load(inheritedProperties);
        return (T)provider.create((Config)builder.build());
    }

    @Override
    public abstract int priority();

    @Override
    public abstract boolean enabled(Context var1);

    @Override
    public PLATFORM initialize(Context context) throws InitializeException {
        String[] provIds;
        this.context = context;
        for (String provId : provIds = this.getProviders()) {
            try {
                this.addProvider(context, provId);
            }
            catch (ProviderException e) {
                throw new InitializeException(e.getMessage());
            }
        }
        return (PLATFORM)this;
    }

    @Override
    public PLATFORM shutdown(Context context) throws ShutdownException {
        return (PLATFORM)this;
    }

    protected abstract String[] getProviders();

    protected void addProvider(Context context, String providerId) throws ProviderException {
        Object provider = context.providers().get(providerId);
        this.providers.put(IOType.getByProviderClass(provider.getClass()), (Provider)provider);
    }
}

