/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.provider.impl;

import com.pi4j.io.IO;
import com.pi4j.io.IOConfig;
import com.pi4j.io.exception.IOAlreadyExistsException;
import com.pi4j.provider.Provider;
import com.pi4j.runtime.Runtime;
import com.pi4j.util.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderProxyHandler
implements InvocationHandler {
    private Runtime runtime = null;
    private Provider provider = null;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ProviderProxyHandler(Runtime runtime, Provider provider) {
        this.runtime = runtime;
        this.provider = provider;
    }

    public Provider provider() {
        return this.provider;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.getName().equalsIgnoreCase("create")) {
            return method.invoke((Object)this.provider, args);
        }
        this.logger.trace("provider [{}({})] invoked '{}({})'", new Object[]{this.provider.getId(), this.provider.getClass().getName(), method.getName(), Arrays.toString(method.getParameterTypes())});
        if (args != null && args.length == 1 && args[0] instanceof IOConfig) {
            IOConfig ioConfig = (IOConfig)args[0];
            if (this.runtime.registry().exists(ioConfig.id())) {
                throw new IOAlreadyExistsException(ioConfig.id());
            }
            IO instance = (IO)method.invoke((Object)this.provider, args);
            instance.initialize(this.runtime.context());
            this.runtime.registry().add(instance);
            return instance;
        }
        if (method.isDefault()) {
            Class<? extends Provider> providerInterface = this.provider.getType().getProviderClass();
            HashSet<Class> interfaces = new HashSet<Class>();
            interfaces.add(this.provider.getType().getProviderClass());
            if (this.provider.getClass().isInterface()) {
                interfaces.add(this.provider.getClass());
            }
            interfaces.addAll(ReflectionUtil.getAllInterfaces(this.provider.getClass()));
            return this.invokeDefaultMethod(interfaces, proxy, method, args);
        }
        throw new UnsupportedOperationException("Method [" + method.getName() + "(" + Arrays.toString(method.getParameterTypes()) + ")] could not be resolved in provider [" + this.provider.id() + "(" + this.provider.getClass().getName() + ")]; Overridden instances of 'create()' are not supported unless defined as default methods in the provider interface.");
    }

    private Object invokeDefaultMethod(Collection<Class> interfaces, Object proxy, Method method, Object[] args) throws Throwable {
        for (Class ifc : interfaces) {
            try {
                return MethodHandles.lookup().findSpecial(ifc, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), ifc).bindTo(proxy).invokeWithArguments(args);
            }
            catch (Throwable e) {
                this.logger.trace(e.getMessage(), e);
            }
        }
        throw new UnsupportedOperationException("Method [" + method.getName() + "(" + Arrays.toString(method.getParameterTypes()) + ")] could not be resolved in provider [" + this.provider.id() + "(" + this.provider.getClass().getName() + ")]; Overridden instances of 'create()' are not supported unless defined as default methods in the provider interface.");
    }
}

