/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.runtime.impl;

import com.pi4j.context.Context;
import com.pi4j.event.EventManager;
import com.pi4j.event.InitializedEvent;
import com.pi4j.event.InitializedListener;
import com.pi4j.event.ShutdownEvent;
import com.pi4j.event.ShutdownListener;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.extension.Plugin;
import com.pi4j.extension.impl.DefaultPluginService;
import com.pi4j.extension.impl.PluginStore;
import com.pi4j.platform.Platform;
import com.pi4j.platform.impl.DefaultRuntimePlatforms;
import com.pi4j.platform.impl.RuntimePlatforms;
import com.pi4j.provider.Provider;
import com.pi4j.provider.impl.DefaultRuntimeProviders;
import com.pi4j.provider.impl.RuntimeProviders;
import com.pi4j.registry.impl.DefaultRuntimeRegistry;
import com.pi4j.registry.impl.RuntimeRegistry;
import com.pi4j.runtime.Runtime;
import com.pi4j.runtime.RuntimeProperties;
import com.pi4j.runtime.impl.DefaultRuntimeProperties;
import com.pi4j.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuntime
implements Runtime {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Context context;
    private final RuntimeRegistry registry;
    private final RuntimeProviders providers;
    private final RuntimePlatforms platforms;
    private final RuntimeProperties properties;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private boolean isShutdown = false;
    private final EventManager<Runtime, ShutdownListener, ShutdownEvent> shutdownEventManager;
    private final EventManager<Runtime, InitializedListener, InitializedEvent> initializedEventManager;

    public static Runtime newInstance(Context context) {
        return new DefaultRuntime(context);
    }

    private DefaultRuntime(Context context) {
        this.context = context;
        this.properties = DefaultRuntimeProperties.newInstance(context);
        this.registry = DefaultRuntimeRegistry.newInstance(this);
        this.providers = DefaultRuntimeProviders.newInstance(this);
        this.platforms = DefaultRuntimePlatforms.newInstance(this);
        this.shutdownEventManager = new EventManager<DefaultRuntime, ShutdownListener, ShutdownEvent>(this, (listener, event) -> listener.onShutdown((ShutdownEvent)event));
        this.initializedEventManager = new EventManager<DefaultRuntime, InitializedListener, InitializedEvent>(this, (listener, event) -> listener.onInitialized((InitializedEvent)event));
        this.logger.debug("Pi4J runtime context successfully created & initialized.'");
        java.lang.Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (!this.isShutdown) {
                    this.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }, "pi4j-shutdown"));
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public RuntimeRegistry registry() {
        return this.registry;
    }

    @Override
    public RuntimeProviders providers() {
        return this.providers;
    }

    @Override
    public RuntimePlatforms platforms() {
        return this.platforms;
    }

    @Override
    public RuntimeProperties properties() {
        return this.properties;
    }

    @Override
    public Runtime shutdown() throws ShutdownException {
        if (!this.isShutdown) {
            this.isShutdown = true;
            this.logger.trace("invoked 'shutdown();'");
            this.shutdownEventManager.dispatch(new ShutdownEvent(this.context), (listener, event) -> listener.beforeShutdown((ShutdownEvent)event));
            try {
                this.registry.shutdown();
                this.platforms.shutdown();
                this.providers.shutdown();
                for (Plugin plugin : this.plugins) {
                    try {
                        plugin.shutdown(this.context);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("failed to 'shutdown(); '", (Throwable)e);
                throw new ShutdownException(e);
            }
            this.logger.debug("Pi4J context/runtime successfully shutdown.'");
            this.shutdownEventManager.dispatch(new ShutdownEvent(this.context));
            this.shutdownEventManager.clear();
        } else {
            this.logger.debug("Pi4J context/runtime is already shutdown.'");
        }
        return this;
    }

    @Override
    public Future<Context> asyncShutdown() {
        return this.executor.submit(() -> {
            try {
                this.shutdown();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return this.context;
        });
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Runtime initialize() throws InitializeException {
        this.logger.trace("invoked 'initialize();'");
        try {
            this.plugins.clear();
            Set<Provider> providers = Collections.synchronizedSet(new HashSet());
            Set<Platform> platforms = Collections.synchronizedSet(new HashSet());
            providers.addAll(this.context().config().getProviders());
            platforms.addAll(this.context().config().getPlatforms());
            if (this.context.config().autoDetectPlatforms() || this.context.config().autoDetectProviders()) {
                ServiceLoader<Plugin> plugins = ServiceLoader.load(Plugin.class);
                for (Plugin plugin : plugins) {
                    if (plugin == null) continue;
                    this.logger.trace("detected plugin: [{}] in classpath; calling 'initialize()'", (Object)plugin.getClass().getName());
                    try {
                        this.plugins.add(plugin);
                        PluginStore store = new PluginStore();
                        plugin.initialize(DefaultPluginService.newInstance(this.context(), store));
                        if (this.context.config().autoDetectProviders()) {
                            providers.addAll(store.providers);
                        }
                        if (!this.context.config().autoDetectPlatforms()) continue;
                        platforms.addAll(store.platforms);
                    }
                    catch (Exception ex) {
                        this.logger.error("unable to 'initialize()' plugin: [{}]; {}", new Object[]{plugin.getClass().getName(), ex.getMessage(), ex});
                    }
                }
            }
            this.registry.initialize();
            this.providers.initialize(providers);
            this.platforms.initialize(platforms);
            try {
                if (this.context().config().autoInject()) {
                    Map<String, String> candidates = PropertiesUtil.keysEndsWith(this.context().properties().all(), "inject");
                    for (String candidateKey : candidates.keySet()) {
                        try {
                            boolean candidateInject = Boolean.parseBoolean(candidates.getOrDefault(candidateKey, "false"));
                            if (!candidateInject) continue;
                            this.context().create(candidateKey);
                        }
                        catch (Exception e) {
                            this.logger.error("FAILED TO AUTO-INJECT [{}]; {}'", new Object[]{candidateKey, e.getMessage(), e});
                            throw new InitializeException(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error("failed to 'initialize(); '", (Throwable)e);
            throw new InitializeException(e);
        }
        this.logger.debug("Pi4J context/runtime successfully initialized.'");
        this.notifyInitListeners();
        return this;
    }

    private void notifyInitListeners() {
    }

    @Override
    public Runtime addListener(ShutdownListener ... listener) {
        return (Runtime)this.shutdownEventManager.add(listener);
    }

    @Override
    public Runtime removeListener(ShutdownListener ... listener) {
        return (Runtime)this.shutdownEventManager.remove(listener);
    }

    @Override
    public Runtime removeAllShutdownListeners() {
        return this.shutdownEventManager.clear();
    }

    @Override
    public Runtime removeAllInitializedListeners() {
        return this.initializedEventManager.clear();
    }

    @Override
    public Runtime addListener(InitializedListener ... listener) {
        return (Runtime)this.initializedEventManager.add(listener);
    }

    @Override
    public Runtime removeListener(InitializedListener ... listener) {
        return (Runtime)this.initializedEventManager.remove(listener);
    }
}

