package com.pi4j.io.group.impl;

/*-
 * #%L
 * **********************************************************************
 * ORGANIZATION  :  Pi4J
 * PROJECT       :  Pi4J :: LIBRARY  :: Java Library (CORE)
 * FILENAME      :  DefaultOnOffGroup.java
 *
 * This file is part of the Pi4J project. More information about
 * this project can be found here:  https://pi4j.com/
 * **********************************************************************
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.pi4j.io.OnOff;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.group.OnOffGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class DefaultOnOffGroup extends GroupBase<OnOffGroup, OnOff> implements OnOffGroup {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean state = false;

    public DefaultOnOffGroup(OnOff ... member){
        add(member);
    }

    @Override
    public boolean isOn() {
        return state;
    }

    @Override
    public OnOffGroup on() throws IOException {
        state = true;
        sync(state);
        return this;
    }

    @Override
    public OnOffGroup off() throws IOException {
        state = false;
        sync(state);
        return this;
    }

    private void sync(boolean state) throws IOException {
        members.forEach(m->{
            try {
                if (state)
                    m.on();
                else
                    m.off();
            }
            catch (IOException e){
                logger.error(e.getMessage(), e);
            }
        });
    }
}
