/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.config;

import com.pi4j.config.Config;
import com.pi4j.config.exception.ConfigMissingRequiredKeyException;
import com.pi4j.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConfigBase<CONFIG_TYPE extends Config>
implements Config<CONFIG_TYPE> {
    protected String id = null;
    protected String name = null;
    protected String description = null;
    protected Map<String, String> properties = new HashMap<String, String>();

    protected ConfigBase() {
    }

    protected ConfigBase(Map<String, String> properties) {
        this.properties.putAll(properties);
        if (properties.containsKey("id")) {
            this.id = properties.get("id");
        }
        if (properties.containsKey("name")) {
            this.name = properties.get("name");
        }
        if (properties.containsKey("description")) {
            this.description = properties.get("description");
        }
    }

    @Override
    public Map<String, String> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public void validate() {
        if (StringUtil.isNullOrEmpty(this.id)) {
            throw new ConfigMissingRequiredKeyException("id");
        }
    }
}

