/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.registry.impl;

import com.pi4j.config.AddressConfig;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.LifecycleException;
import com.pi4j.io.IO;
import com.pi4j.io.exception.IOAlreadyExistsException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.exception.IOInvalidIDException;
import com.pi4j.io.exception.IONotFoundException;
import com.pi4j.io.exception.IOShutdownException;
import com.pi4j.registry.impl.RuntimeRegistry;
import com.pi4j.runtime.Runtime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuntimeRegistry
implements RuntimeRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRuntimeRegistry.class);
    private Runtime runtime;
    private final Map<String, IO> instances = new HashMap<String, IO>();
    private final Set<Integer> usedAddresses = new HashSet<Integer>();

    public static RuntimeRegistry newInstance(Runtime runtime) {
        return new DefaultRuntimeRegistry(runtime);
    }

    private DefaultRuntimeRegistry(Runtime runtime) {
        this.runtime = runtime;
    }

    @Override
    public synchronized RuntimeRegistry add(IO instance) throws IOInvalidIDException, IOAlreadyExistsException {
        String _id = this.validateId(instance.id());
        if (this.instances.containsKey(_id)) {
            throw new IOAlreadyExistsException(_id);
        }
        if (instance.config() instanceof AddressConfig) {
            AddressConfig addressConfig = (AddressConfig)instance.config();
            if (this.exists(addressConfig.address())) {
                throw new IOAlreadyExistsException(addressConfig.address());
            }
            this.usedAddresses.add(addressConfig.address());
        }
        try {
            instance.initialize(this.runtime.context());
            this.instances.put(_id, instance);
        }
        catch (InitializeException e) {
            if (instance.config() instanceof AddressConfig) {
                AddressConfig addressConfig = (AddressConfig)instance.config();
                this.usedAddresses.remove(addressConfig.address());
            }
            throw new IllegalStateException("Failed to initialize IO " + instance.getId(), e);
        }
        return this;
    }

    @Override
    public synchronized <T extends IO> T get(String id, Class<T> type) throws IOInvalidIDException, IONotFoundException {
        String _id = this.validateId(id);
        if (!this.instances.containsKey(_id)) {
            throw new IONotFoundException(_id);
        }
        return (T)this.instances.get(_id);
    }

    @Override
    public synchronized <T extends IO> T get(String id) throws IOInvalidIDException, IONotFoundException {
        String _id = this.validateId(id);
        if (!this.instances.containsKey(_id)) {
            throw new IONotFoundException(_id);
        }
        return (T)this.instances.get(_id);
    }

    @Override
    public synchronized <T extends IO> T remove(String id) throws IONotFoundException, IOInvalidIDException, IOShutdownException {
        String _id = this.validateId(id);
        IO shutdownInstance = null;
        if (!this.exists(_id)) {
            throw new IONotFoundException(_id);
        }
        try {
            long start = System.currentTimeMillis();
            shutdownInstance = this.instances.get(_id);
            shutdownInstance.shutdown(this.runtime.context());
            long took = System.currentTimeMillis() - start;
            if (took > 10L) {
                logger.warn("Shutting down of IO " + shutdownInstance.getId() + " took " + took + "ms");
            }
        }
        catch (LifecycleException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOShutdownException(shutdownInstance, e);
        }
        if (shutdownInstance.config() instanceof AddressConfig) {
            AddressConfig addressConfig = (AddressConfig)shutdownInstance.config();
            this.usedAddresses.remove(addressConfig.address());
        }
        this.instances.remove(_id);
        return (T)shutdownInstance;
    }

    @Override
    public synchronized boolean exists(String id) {
        String _id = null;
        try {
            _id = this.validateId(id);
            return this.instances.containsKey(_id);
        }
        catch (IOInvalidIDException e) {
            return false;
        }
    }

    @Override
    public synchronized boolean exists(int address) {
        return this.usedAddresses.contains(address);
    }

    @Override
    public synchronized Map<String, ? extends IO> all() {
        return new HashMap<String, IO>(this.instances);
    }

    private String validateId(String id) throws IOInvalidIDException {
        if (id == null) {
            throw new IOInvalidIDException();
        }
        String validatedId = id.trim();
        if (validatedId.isEmpty()) {
            throw new IOInvalidIDException();
        }
        return validatedId;
    }

    @Override
    public synchronized RuntimeRegistry shutdown() {
        this.all().values().forEach(instance -> {
            try {
                this.remove(instance.id());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        return this;
    }

    @Override
    public RuntimeRegistry initialize() throws InitializeException {
        return this;
    }
}

