/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial.impl;

import com.pi4j.io.gpio.digital.PullResistance;
import com.pi4j.io.impl.IODeviceConfigBase;
import com.pi4j.io.serial.DataBits;
import com.pi4j.io.serial.FlowControl;
import com.pi4j.io.serial.Parity;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.StopBits;
import com.pi4j.util.StringUtil;
import java.util.Map;

public class DefaultSerialConfig
extends IODeviceConfigBase<SerialConfig>
implements SerialConfig {
    protected final Integer baud;
    protected final StopBits stopBits;
    protected final DataBits dataBits;
    protected final Parity parity;
    protected final FlowControl flowControl;
    protected PullResistance pullResistance = PullResistance.OFF;

    protected DefaultSerialConfig(Map<String, String> properties) {
        super(properties);
        this.id = StringUtil.setIfNullOrEmpty(this.id, "SERIAL-" + this.device, true);
        this.name = StringUtil.setIfNullOrEmpty(this.name, "SERIAL-" + this.device, true);
        this.description = StringUtil.setIfNullOrEmpty(this.description, "SERIAL-" + this.device, true);
        this.baud = properties.containsKey("baud") ? Integer.valueOf(StringUtil.parseInteger(properties.get("baud"), 9600)) : Integer.valueOf(9600);
        this.dataBits = properties.containsKey("data-bits") ? DataBits.parse(properties.get("data-bits")) : Serial.DEFAULT_DATA_BITS;
        this.parity = properties.containsKey("parity") ? Parity.parse(properties.get("parity")) : Serial.DEFAULT_PARITY;
        this.stopBits = properties.containsKey("stop-bits") ? StopBits.parse(properties.get("stop-bits")) : Serial.DEFAULT_STOP_BITS;
        this.flowControl = properties.containsKey("flow-control") ? FlowControl.parse(properties.get("flow-control")) : Serial.DEFAULT_FLOW_CONTROL;
    }

    @Override
    public Integer baud() {
        return this.baud;
    }

    @Override
    public StopBits stopBits() {
        return this.stopBits;
    }

    @Override
    public DataBits dataBits() {
        return this.dataBits;
    }

    @Override
    public Parity parity() {
        return this.parity;
    }

    @Override
    public FlowControl flowControl() {
        return this.flowControl;
    }
}

