/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.provider;

import com.pi4j.common.Descriptor;
import com.pi4j.config.Config;
import com.pi4j.context.Context;
import com.pi4j.extension.Extension;
import com.pi4j.io.IO;
import com.pi4j.io.IOType;
import com.pi4j.io.exception.IOException;
import com.pi4j.util.PropertiesUtil;
import java.util.Map;

public interface Provider<PROVIDER_TYPE extends Provider, IO_TYPE extends IO, CONFIG_TYPE extends Config>
extends Extension<PROVIDER_TYPE> {
    public Context context();

    public IO_TYPE create(CONFIG_TYPE var1);

    default public IOType type() {
        return IOType.getByProviderClass(this.getClass());
    }

    default public IOType getType() {
        return this.type();
    }

    default public int getPriority() {
        return 0;
    }

    default public boolean isType(IOType type) {
        return this.type().isType(type);
    }

    @Override
    default public Descriptor describe() {
        Descriptor descriptor = Extension.super.describe();
        descriptor.category("PROVIDER");
        return descriptor;
    }

    default public IO_TYPE create(String id) {
        if (this.context() == null) {
            throw new IOException("Unable to create IO instance; this provider has not been 'initialized()' with a Pi4J context.");
        }
        Map<String, String> inheritedProperties = PropertiesUtil.subProperties(this.context().properties().all(), id);
        Object builder = this.type().newConfigBuilder(this.context());
        builder.id(id);
        builder.load(inheritedProperties);
        return this.create((Config)builder.build());
    }
}

