/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardReading {
    private static final Logger logger = LoggerFactory.getLogger(BoardReading.class);
    private final String boardCode;
    private final String boardVersionCode;
    private final String temperature;
    private final String uptimeInfo;
    private final String volt;
    private final String memory;

    public BoardReading(String boardCode, String boardVersionCode, String temperature, String uptimeInfo, String volt, String memory) {
        this.boardCode = boardCode;
        this.boardVersionCode = boardVersionCode;
        this.temperature = temperature;
        this.uptimeInfo = uptimeInfo;
        this.volt = volt;
        this.memory = memory;
    }

    public String getBoardCode() {
        return this.boardCode;
    }

    public String getBoardVersionCode() {
        return this.boardVersionCode;
    }

    public String getTemperature() {
        return this.temperature;
    }

    public String getUptimeInfo() {
        return this.uptimeInfo;
    }

    public String getVolt() {
        return this.volt;
    }

    public String getMemory() {
        return this.memory;
    }

    public double getTemperatureInCelsius() {
        if (this.temperature.contains("temp=")) {
            try {
                return Double.parseDouble(this.temperature.replace("temp=", "").replace("'C", "").replace("\u00b0C", ""));
            }
            catch (Exception e) {
                logger.error("Can't convert temperature value: {}", (Object)e.getMessage());
            }
        }
        return 0.0;
    }

    public double getTemperatureInFahrenheit() {
        return this.getTemperatureInCelsius() * 1.8 + 32.0;
    }

    public double getVoltValue() {
        if (this.volt.contains("volt=")) {
            try {
                return Double.parseDouble(this.volt.replace("volt=", "").replace("V", ""));
            }
            catch (Exception e) {
                logger.error("Can't convert volt value: {}", (Object)e.getMessage());
            }
        }
        return 0.0;
    }
}

