/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.registry;

import com.pi4j.common.Describable;
import com.pi4j.common.Descriptor;
import com.pi4j.common.Identity;
import com.pi4j.io.IO;
import com.pi4j.io.IOType;
import com.pi4j.io.exception.IOAlreadyExistsException;
import com.pi4j.io.exception.IOInvalidIDException;
import com.pi4j.io.exception.IONotFoundException;
import com.pi4j.io.exception.IOShutdownException;
import com.pi4j.provider.Provider;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public interface Registry
extends Describable {
    public boolean exists(String var1);

    public boolean exists(int var1);

    public Map<String, ? extends IO> all();

    public <T extends IO> T get(String var1) throws IOInvalidIDException, IONotFoundException;

    public <T extends IO> T get(String var1, Class<T> var2) throws IOInvalidIDException, IONotFoundException;

    default public <T extends IO> Map<String, T> allByType(Class<T> ioClass) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        this.all().values().stream().filter(ioClass::isInstance).forEach(p -> result.put(p.id(), (IO)ioClass.cast(p)));
        return Collections.unmodifiableMap(result);
    }

    default public <P extends Provider> Map<String, ? extends IO> allByIoType(IOType ioType) {
        return this.allByType(ioType.getIOClass());
    }

    default public <P extends Provider> Map<String, ? extends IO> allByProvider(Class<P> providerClass) {
        return this.allByIoType(IOType.getByProviderClass(providerClass));
    }

    default public <P extends Provider> Map<String, ? extends IO> allByProvider(String providerId) {
        Map<String, IO> result = this.all().values().stream().filter(instance -> providerId.equalsIgnoreCase(instance.provider().id())).collect(Collectors.toMap(Identity::id, c -> c));
        return Collections.unmodifiableMap(result);
    }

    default public <P extends Provider, T extends IO> Map<String, T> allByProvider(String providerId, Class<T> ioClass) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        this.all().values().stream().filter(instance -> providerId.equalsIgnoreCase(instance.provider().id())).filter(ioClass::isInstance).forEach(p -> result.put(p.id(), (IO)ioClass.cast(p)));
        return Collections.unmodifiableMap(result);
    }

    public Registry add(IO var1) throws IOAlreadyExistsException, IOInvalidIDException;

    public <T extends IO> T remove(String var1) throws IONotFoundException, IOInvalidIDException, IOShutdownException;

    @Override
    default public Descriptor describe() {
        Map<String, ? extends IO> instances = this.all();
        Descriptor descriptor = Descriptor.create().category("REGISTRY").name("I/O Registered Instances").quantity(instances == null ? 0 : instances.size()).type(this.getClass());
        if (instances != null && !instances.isEmpty()) {
            instances.forEach((id, instance) -> descriptor.add(instance.describe()));
        }
        return descriptor;
    }
}

