/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.definition;

import com.pi4j.boardinfo.definition.BoardType;
import com.pi4j.boardinfo.definition.Cpu;
import com.pi4j.boardinfo.definition.HeaderVersion;
import com.pi4j.boardinfo.definition.PiModel;
import com.pi4j.boardinfo.definition.Soc;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BoardModel {
    MODEL_1_A("Raspberry Pi 1 Model A", BoardType.SINGLE_BOARD_COMPUTER, new ArrayList<String>(), PiModel.MODEL_A, HeaderVersion.TYPE_1, LocalDate.of(2013, 2, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, Collections.singletonList(700), Collections.singletonList(262144)),
    MODEL_1_A_PLUS("Raspberry Pi 1 Model A+", BoardType.SINGLE_BOARD_COMPUTER, Collections.singletonList("900021"), PiModel.MODEL_A, HeaderVersion.TYPE_1, LocalDate.of(2014, 11, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, Collections.singletonList(700), Arrays.asList(262144, 524288), Collections.singletonList("Amount of memory changed to 512Mb on 20160810")),
    MODEL_3_A_PLUS("Raspberry Pi 3 Model A+", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("9020e0", "9020e1"), PiModel.MODEL_A, HeaderVersion.TYPE_3, LocalDate.of(2018, 11, 1), Soc.BCM2837B0, Cpu.CORTEX_A53, 4, Collections.singletonList(1400), Collections.singletonList(524288)),
    MODEL_1_B("Raspberry Pi 1 Model B", BoardType.SINGLE_BOARD_COMPUTER, new ArrayList<String>(), PiModel.MODEL_B, HeaderVersion.TYPE_1, LocalDate.of(2012, 4, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, Collections.singletonList(700), Arrays.asList(262144, 524288), Collections.singletonList("Amount of memory changed to 512Mb on 20121015")),
    MODEL_1_B_PLUS("Raspberry Pi 1 Model B+", BoardType.SINGLE_BOARD_COMPUTER, Collections.singletonList("900032"), PiModel.MODEL_B, HeaderVersion.TYPE_1, LocalDate.of(2014, 7, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, Collections.singletonList(700), Collections.singletonList(524288)),
    MODEL_2_B("Raspberry Pi 2 Model B", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("a01040", "a01041", "a21041"), PiModel.MODEL_B, HeaderVersion.TYPE_2, LocalDate.of(2015, 2, 1), Soc.BCM2836, Cpu.CORTEX_A7, 4, Collections.singletonList(900), Collections.singletonList(0x100000)),
    MODEL_2_B_V1_2("Raspberry Pi 2 Model B V1.2", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("a02042", "a22042"), PiModel.MODEL_B, HeaderVersion.TYPE_2, LocalDate.of(2016, 10, 1), Soc.BCM2837, Cpu.CORTEX_A53, 4, Collections.singletonList(900), Collections.singletonList(0x100000)),
    MODEL_3_B("Raspberry Pi 3 Model B", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("a02082", "a22082", "a32082", "a52082", "a22083"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2016, 2, 1), Soc.BCM2837, Cpu.CORTEX_A53, 4, Collections.singletonList(1200), Collections.singletonList(0x100000)),
    MODEL_3_B_PLUS("Raspberry Pi 3 Model B+", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("a020d3", "a020d4"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2018, 3, 14), Soc.BCM2837B0, Cpu.CORTEX_A53, 4, Collections.singletonList(1400), Collections.singletonList(0x100000)),
    MODEL_4_B("Raspberry Pi 4 Model B", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("a03111", "b03111", "b03112", "b03114", "b03115", "c03111", "c03112", "c03114", "c03115", "d03114", "d03115"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2019, 6, 24), Soc.BCM2711, Cpu.CORTEX_A72, 4, Arrays.asList(1500, 1800), Arrays.asList(0x100000, 0x200000, 0x400000, 0x800000)),
    MODEL_400("Raspberry Pi 400", BoardType.ALL_IN_ONE_COMPUTER, Collections.singletonList("c03130"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2020, 11, 2), Soc.BCM2711C0, Cpu.CORTEX_A72, 4, Collections.singletonList(1800), Collections.singletonList(0x400000)),
    MODEL_5_B("Raspberry Pi 5 Model B", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("b04170", "c04170", "d04170"), PiModel.MODEL_B, HeaderVersion.TYPE_3, LocalDate.of(2023, 9, 28), Soc.BCM2712, Cpu.CORTEX_A76, 4, Collections.singletonList(2400), Arrays.asList(0x200000, 0x400000, 0x800000)),
    COMPUTE_1("Compute Module 1", BoardType.STACK_ON_COMPUTER, Collections.singletonList("900061"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2014, 4, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, Collections.singletonList(700), Collections.singletonList(524288)),
    COMPUTE_3("Compute Module 3", BoardType.STACK_ON_COMPUTER, Arrays.asList("a020a0", "a220a0"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2017, 1, 1), Soc.BCM2837, Cpu.CORTEX_A53, 4, Collections.singletonList(1200), Collections.singletonList(0x100000)),
    COMPUTE_3_PLUS("Compute Module 3+", BoardType.STACK_ON_COMPUTER, Collections.singletonList("a02100"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2019, 1, 1), Soc.BCM2837B0, Cpu.CORTEX_A53, 4, Collections.singletonList(1200), Collections.singletonList(0x100000)),
    COMPUTE_4("Compute Module 4", BoardType.STACK_ON_COMPUTER, Arrays.asList("a03140", "b03140", "c03140", "d03140", "a03141", "b03141", "c03141", "d03141"), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2020, 10, 1), Soc.BCM2711, Cpu.CORTEX_A72, 4, Collections.singletonList(1500), Arrays.asList(0x100000, 0x200000, 0x400000, 0x800000)),
    COMPUTE_4_SODIMM("Compute Module 4 SODIMM", BoardType.STACK_ON_COMPUTER, new ArrayList<String>(), PiModel.COMPUTE, HeaderVersion.COMPUTE, LocalDate.of(2020, 10, 1), Soc.BCM2711, Cpu.CORTEX_A72, 4, Collections.singletonList(1500), Arrays.asList(0x100000, 0x200000, 0x400000, 0x800000)),
    ZERO_PCB_1_2("Raspberry Pi Zero PCB V1.2", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("900092", "920092"), PiModel.ZERO, HeaderVersion.TYPE_3, LocalDate.of(2015, 11, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, Collections.singletonList(1000), Collections.singletonList(524288)),
    ZERO_PCB_1_3("Raspberry Pi Zero PCB V1.3", BoardType.SINGLE_BOARD_COMPUTER, Arrays.asList("900093", "920093"), PiModel.ZERO, HeaderVersion.TYPE_3, LocalDate.of(2016, 5, 1), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, Collections.singletonList(1000), Collections.singletonList(524288)),
    ZERO_W("Raspberry Pi Zero W", BoardType.SINGLE_BOARD_COMPUTER, Collections.singletonList("9000c1"), PiModel.ZERO, HeaderVersion.TYPE_3, LocalDate.of(2017, 2, 28), Soc.BCM2835, Cpu.ARM1176JZF_S, 1, Collections.singletonList(1000), Collections.singletonList(524288)),
    ZERO_V2("Raspberry Pi Zero V2", BoardType.SINGLE_BOARD_COMPUTER, Collections.singletonList("902120"), PiModel.ZERO, HeaderVersion.TYPE_3, LocalDate.of(2021, 10, 28), Soc.BCM2710A1, Cpu.CORTEX_A53, 4, Collections.singletonList(1000), Collections.singletonList(524288)),
    PICO("Raspberry Pi Pico", BoardType.MICROCONTROLLER, new ArrayList<String>(), PiModel.PICO, HeaderVersion.PICO, LocalDate.of(2021, 1, 1), Soc.RP2040, Cpu.CORTEX_MO_PLUS, 1, Collections.singletonList(133), Collections.singletonList(2312)),
    PICO_W("Raspberry Pi Pico W", BoardType.MICROCONTROLLER, new ArrayList<String>(), PiModel.PICO, HeaderVersion.PICO, LocalDate.of(2022, 6, 1), Soc.RP2040, Cpu.CORTEX_MO_PLUS, 1, Collections.singletonList(133), Collections.singletonList(2312), Collections.singletonList("Same form factor as PICO but with Wi-Fi")),
    PICO_2("Raspberry Pi Pico 2", BoardType.MICROCONTROLLER, new ArrayList<String>(), PiModel.PICO, HeaderVersion.PICO, LocalDate.of(2024, 8, 8), Soc.RP2350, Cpu.CORTEX_M33, 1, Collections.singletonList(150), Collections.singletonList(4616)),
    PICO_2_W("Raspberry Pi Pico 2 W", BoardType.MICROCONTROLLER, new ArrayList<String>(), PiModel.PICO, HeaderVersion.PICO, LocalDate.of(2024, 8, 8), Soc.RP2350, Cpu.CORTEX_M33, 1, Collections.singletonList(150), Collections.singletonList(4616)),
    UNKNOWN("Unknown", BoardType.UNKNOWN, new ArrayList<String>(), PiModel.UNKNOWN, HeaderVersion.UNKNOWN, null, Soc.UNKNOWN, Cpu.UNKNOWN, 0, new ArrayList<Integer>(), new ArrayList<Integer>());

    private static final Logger logger;
    private final String label;
    private final BoardType boardType;
    private final List<String> boardCodes;
    private final PiModel model;
    private final HeaderVersion headerVersion;
    private final LocalDate releaseDate;
    private final Soc soc;
    private final Cpu cpu;
    private final Integer numberOfCpu;
    private final List<Integer> versionsProcessorSpeedInMhz;
    private final List<Integer> versionsMemoryInKb;
    private final List<String> remarks;

    private BoardModel(String label, BoardType boardType, List<String> boardCodes, PiModel model, HeaderVersion headerVersion, LocalDate releaseDate, Soc soc, Cpu cpu, Integer numberOfCpu, List<Integer> versionsProcessorSpeedInMhz, List<Integer> versionsMemoryInKb) {
        this(label, boardType, boardCodes, model, headerVersion, releaseDate, soc, cpu, numberOfCpu, versionsProcessorSpeedInMhz, versionsMemoryInKb, new ArrayList<String>());
    }

    private BoardModel(String label, BoardType boardType, List<String> boardCodes, PiModel model, HeaderVersion headerVersion, LocalDate releaseDate, Soc soc, Cpu cpu, Integer numberOfCpu, List<Integer> versionsProcessorSpeedInMhz, List<Integer> versionsMemoryInKb, List<String> remarks) {
        this.label = label;
        this.boardType = boardType;
        this.boardCodes = boardCodes;
        this.model = model;
        this.headerVersion = headerVersion;
        this.releaseDate = releaseDate;
        this.soc = soc;
        this.cpu = cpu;
        this.numberOfCpu = numberOfCpu;
        this.versionsProcessorSpeedInMhz = versionsProcessorSpeedInMhz;
        this.versionsMemoryInKb = versionsMemoryInKb;
        this.remarks = remarks;
    }

    public static BoardModel getByBoardCode(String boardCode) throws Exception {
        List matches = Arrays.stream(BoardModel.values()).filter(bm -> bm.boardCodes.contains(boardCode)).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return UNKNOWN;
        }
        if (matches.size() > 1) {
            throw new Exception("Too many matching models found for code " + boardCode + ", probably an error in the definitions");
        }
        return (BoardModel)((Object)matches.get(0));
    }

    public static BoardModel getByBoardName(String boardName) {
        List matches = Arrays.stream(BoardModel.values()).filter(bm -> boardName.toLowerCase().startsWith(bm.label.toLowerCase())).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return UNKNOWN;
        }
        if (matches.size() > 1) {
            logger.error("Too many matching models found for name {}, the given name is not exclusive enough", (Object)boardName);
        }
        return (BoardModel)((Object)matches.get(0));
    }

    public static List<String> getAllBoardCodes() {
        return Arrays.stream(BoardModel.values()).map(b -> b.boardCodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getName() {
        return this.name();
    }

    public String getLabel() {
        return this.label;
    }

    public BoardType getBoardType() {
        return this.boardType;
    }

    public List<String> getBoardCodes() {
        return this.boardCodes;
    }

    public PiModel getModel() {
        return this.model;
    }

    public HeaderVersion getHeaderVersion() {
        return this.headerVersion;
    }

    public LocalDate getReleaseDate() {
        return this.releaseDate;
    }

    public Soc getSoc() {
        return this.soc;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Integer getNumberOfCpu() {
        return this.numberOfCpu;
    }

    public List<Integer> getVersionsProcessorSpeedInMhz() {
        return this.versionsProcessorSpeedInMhz;
    }

    public List<Integer> getVersionsMemoryInKb() {
        return this.versionsMemoryInKb;
    }

    public List<Float> getVersionsMemoryInMb() {
        return this.versionsMemoryInKb.stream().map(m -> Float.valueOf((float)m.intValue() / 1024.0f)).collect(Collectors.toList());
    }

    public List<Float> getVersionsMemoryInGb() {
        return this.versionsMemoryInKb.stream().map(m -> Float.valueOf((float)m.intValue() / 1024.0f / 1024.0f)).collect(Collectors.toList());
    }

    public List<String> getRemarks() {
        return this.remarks;
    }

    static {
        logger = LoggerFactory.getLogger(BoardModel.class);
    }
}

