/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.util;

import com.pi4j.boardinfo.definition.BoardModel;
import com.pi4j.boardinfo.model.BoardInfo;
import com.pi4j.boardinfo.model.BoardReading;
import com.pi4j.boardinfo.model.JavaInfo;
import com.pi4j.boardinfo.model.JvmMemory;
import com.pi4j.boardinfo.model.OperatingSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardInfoHelper {
    private static final Logger logger = LoggerFactory.getLogger(BoardInfoHelper.class);
    private static final BoardInfoHelper instance = new BoardInfoHelper();
    private BoardInfo boardInfo;

    private BoardInfoHelper() {
        OperatingSystem os = new OperatingSystem(System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        logger.info("Detected OS: {}", (Object)os);
        JavaInfo java = new JavaInfo(System.getProperty("java.version"), System.getProperty("java.runtime.version"), System.getProperty("java.vendor"), System.getProperty("java.vendor.version"));
        logger.info("Detected Java: {}", (Object)java);
        String boardVersionCode = BoardInfoHelper.getBoardVersionCode();
        try {
            BoardModel boardModelByBoardCode = BoardModel.getByBoardCode(boardVersionCode);
            if (boardModelByBoardCode != BoardModel.UNKNOWN) {
                logger.info("Detected board type {} by code: {}", (Object)boardModelByBoardCode.name(), (Object)boardVersionCode);
                this.boardInfo = new BoardInfo(boardModelByBoardCode, os, java);
                return;
            }
        }
        catch (Exception e) {
            logger.warn("Could not detect the board type for code {}: {}", (Object)boardVersionCode, (Object)e.getMessage());
        }
        String boardName = BoardInfoHelper.getBoardName();
        BoardModel boardModelByBoardName = BoardModel.getByBoardName(boardName);
        if (boardModelByBoardName != BoardModel.UNKNOWN) {
            logger.info("Detected board type {} by name: {}", (Object)boardModelByBoardName.name(), (Object)boardName);
            this.boardInfo = new BoardInfo(boardModelByBoardName, os, java);
            return;
        }
        logger.warn("Sorry, could not detect the board type");
        this.boardInfo = new BoardInfo(BoardModel.UNKNOWN, os, java);
    }

    public static BoardInfo current() {
        return BoardInfoHelper.instance.boardInfo;
    }

    public static boolean usesRP1() {
        return BoardInfoHelper.instance.boardInfo.getBoardModel() == BoardModel.MODEL_5_B;
    }

    public static boolean runningOnRaspberryPi() {
        return BoardInfoHelper.instance.boardInfo.getBoardModel() != BoardModel.UNKNOWN;
    }

    public static boolean is32bit() {
        return !BoardInfoHelper.is64bit();
    }

    public static boolean is64bit() {
        return System.getProperty("sun.arch.data.model").equals("64");
    }

    public static String getBoardVersionCode() {
        CommandResult output = BoardInfoHelper.getCommandOutput("cat /proc/cpuinfo | grep 'Revision' | awk '{print $3}'");
        if (output.isSuccess()) {
            return output.getOutputMessage();
        }
        logger.error("Could not get the board version code: {}", (Object)output.getErrorMessage());
        return "";
    }

    public static String getBoardName() {
        CommandResult output = BoardInfoHelper.getCommandOutput("cat /proc/device-tree/model");
        if (output.isSuccess()) {
            return output.getOutputMessage();
        }
        logger.error("Could not get the board name: {}", (Object)output.getErrorMessage());
        return "";
    }

    public static JvmMemory getJvmMemory() {
        return new JvmMemory(Runtime.getRuntime());
    }

    public static BoardReading getBoardReading() {
        return new BoardReading(BoardInfoHelper.getCommandOutput("cat /proc/device-tree/model").getOutputMessage(), BoardInfoHelper.getCommandOutput("cat /proc/cpuinfo | grep 'Revision' | awk '{print $3}'").getOutputMessage(), BoardInfoHelper.getCommandOutput("vcgencmd measure_temp").getOutputMessage(), BoardInfoHelper.getCommandOutput("uptime").getOutputMessage(), BoardInfoHelper.getCommandOutput("vcgencmd measure_volts").getOutputMessage(), BoardInfoHelper.getCommandOutput("cat /proc/meminfo | head -n 1").getOutputMessage());
    }

    private static CommandResult getCommandOutput(String command) {
        boolean finished = false;
        String outputMessage = "";
        Object errorMessage = "";
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("sh", "-c", command);
        try {
            Process process = builder.start();
            OutputStream outputStream = process.getOutputStream();
            InputStream inputStream = process.getInputStream();
            InputStream errorStream = process.getErrorStream();
            outputMessage = BoardInfoHelper.readStream(inputStream);
            errorMessage = BoardInfoHelper.readStream(errorStream);
            finished = process.waitFor(30L, TimeUnit.SECONDS);
            outputStream.flush();
            outputStream.close();
            if (!finished) {
                process.destroyForcibly();
            }
        }
        catch (IOException ex) {
            errorMessage = "IOException: " + ex.getMessage();
        }
        catch (InterruptedException ex) {
            errorMessage = "InterruptedException: " + ex.getMessage();
        }
        if (!finished || !((String)errorMessage).isEmpty()) {
            logger.error("Could not execute '{}' to detect the board model: {}", (Object)command, errorMessage);
            return new CommandResult(false, outputMessage, (String)errorMessage);
        }
        return new CommandResult(true, outputMessage, (String)errorMessage);
    }

    private static String readStream(InputStream inputStream) {
        StringBuilder rt = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                rt.append(line);
            }
        }
        catch (Exception ex) {
            rt.append("ERROR: ").append(ex.getMessage());
        }
        return rt.toString();
    }

    private static class CommandResult {
        private final boolean success;
        private final String outputMessage;
        private final String errorMessage;

        public CommandResult(boolean success, String outputMessage, String errorMessage) {
            this.success = success;
            this.outputMessage = outputMessage;
            this.errorMessage = errorMessage;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getOutputMessage() {
            return this.outputMessage;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

