/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.context.impl;

import com.pi4j.boardinfo.util.BoardInfoHelper;
import com.pi4j.context.Context;
import com.pi4j.context.ContextBuilder;
import com.pi4j.context.ContextConfig;
import com.pi4j.context.impl.DefaultContext;
import com.pi4j.exception.Pi4JException;
import com.pi4j.platform.Platform;
import com.pi4j.provider.Provider;
import com.pi4j.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextBuilder
implements ContextBuilder {
    protected Logger logger = LoggerFactory.getLogger(DefaultContextBuilder.class);
    protected boolean autoDetectMockPlugins = !BoardInfoHelper.runningOnRaspberryPi();
    protected boolean autoDetectPlatforms = false;
    protected boolean autoDetectProviders = false;
    protected boolean autoInject = false;
    protected boolean enableShutdownHook = false;
    protected String defaultPlatformId = null;
    protected Collection<Platform> platforms = Collections.synchronizedList(new ArrayList());
    protected Collection<Provider> providers = Collections.synchronizedList(new ArrayList());
    protected Map<String, String> properties = Collections.synchronizedMap(new HashMap());

    private DefaultContextBuilder() {
    }

    public static ContextBuilder newInstance() {
        return new DefaultContextBuilder();
    }

    @Override
    public ContextBuilder add(Platform ... platform) {
        if (platform != null && platform.length > 0) {
            this.platforms.addAll(Arrays.asList(platform));
        }
        return this;
    }

    @Override
    public ContextBuilder add(Provider ... provider) {
        if (provider != null && provider.length > 0) {
            this.providers.addAll(Arrays.asList(provider));
        }
        return this;
    }

    @Override
    public String defaultPlatform() {
        return this.defaultPlatformId;
    }

    @Override
    public ContextBuilder defaultPlatform(String platformId) {
        this.defaultPlatformId = platformId;
        return this;
    }

    @Override
    public ContextBuilder autoDetectMockPlugins() {
        this.autoDetectMockPlugins = true;
        return this;
    }

    @Override
    public ContextBuilder autoDetectPlatforms() {
        this.autoDetectPlatforms = true;
        return this;
    }

    @Override
    public ContextBuilder noAutoDetectPlatforms() {
        this.autoDetectPlatforms = false;
        return this;
    }

    @Override
    public ContextBuilder autoDetectProviders() {
        this.autoDetectProviders = true;
        return this;
    }

    @Override
    public ContextBuilder noAutoDetectProviders() {
        this.autoDetectProviders = false;
        return this;
    }

    @Override
    public ContextBuilder autoInject() {
        this.autoInject = true;
        return this;
    }

    @Override
    public ContextBuilder noAutoInject() {
        this.autoInject = false;
        return this;
    }

    @Override
    public ContextBuilder enableShutdownHook() {
        this.enableShutdownHook = true;
        return this;
    }

    @Override
    public ContextBuilder disableShutdownHook() {
        this.enableShutdownHook = false;
        return this;
    }

    @Override
    public ContextBuilder property(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public ContextBuilder property(Map.Entry<String, String> ... value) {
        for (Map.Entry<String, String> e : value) {
            this.properties.put(e.getKey().toString(), e.getValue().toString());
        }
        return this;
    }

    @Override
    public ContextBuilder properties(Properties properties, String prefixFilter) {
        Map<String, String> entries = properties.keySet().stream().collect(Collectors.toMap(k -> k.toString(), key -> properties.get(key).toString()));
        return this.properties(entries, prefixFilter);
    }

    @Override
    public ContextBuilder properties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    @Override
    public ContextBuilder properties(Map<String, String> properties, String prefixFilter) {
        if (StringUtil.isNullOrEmpty(prefixFilter)) {
            return this.properties(properties);
        }
        Object prefix = prefixFilter.endsWith(".") ? prefixFilter : prefixFilter + ".";
        properties.keySet().stream().filter(arg_0 -> DefaultContextBuilder.lambda$properties$2((String)prefix, arg_0)).forEach(arg_0 -> this.lambda$properties$3((String)prefix, properties, arg_0));
        return this;
    }

    @Override
    public ContextBuilder properties(InputStream stream, String prefixFilter) throws IOException {
        Properties prop = new Properties();
        prop.load(stream);
        return this.properties(prop, prefixFilter);
    }

    @Override
    public ContextBuilder properties(Reader reader, String prefixFilter) throws IOException {
        Properties prop = new Properties();
        prop.load(reader);
        return this.properties(prop, prefixFilter);
    }

    @Override
    public ContextBuilder properties(File file, String prefixFilter) throws IOException {
        Properties prop = new Properties();
        prop.load(new FileInputStream(file));
        return this.properties(prop, prefixFilter);
    }

    @Override
    public ContextConfig toConfig() {
        final DefaultContextBuilder builder = this;
        return new ContextConfig(){

            @Override
            public Collection<Platform> platforms() {
                return Collections.unmodifiableCollection(builder.platforms);
            }

            @Override
            public Collection<Provider> providers() {
                return Collections.unmodifiableCollection(builder.providers);
            }

            @Override
            public String defaultPlatform() {
                return builder.defaultPlatformId;
            }

            @Override
            public boolean autoDetectMockPlugins() {
                return builder.autoDetectMockPlugins;
            }

            @Override
            public boolean autoDetectPlatforms() {
                return builder.autoDetectPlatforms;
            }

            @Override
            public boolean enableShutdownHook() {
                return builder.enableShutdownHook;
            }

            @Override
            public boolean autoInject() {
                return builder.autoInject;
            }

            @Override
            public boolean autoDetectProviders() {
                return builder.autoDetectProviders;
            }

            @Override
            public Map<String, String> properties() {
                return Collections.unmodifiableMap(builder.properties);
            }
        };
    }

    @Override
    public Context build() throws Pi4JException {
        this.logger.trace("invoked 'build()'");
        Context context = DefaultContext.newInstance(this.toConfig());
        this.logger.debug("Pi4J successfully created and initialized a new runtime 'Context'.'");
        return context;
    }

    private /* synthetic */ void lambda$properties$3(String prefix, Map properties, String key) {
        this.properties.put(key.substring(prefix.length()), (String)properties.get(key));
    }

    private static /* synthetic */ boolean lambda$properties$2(String prefix, String key) {
        return key.startsWith(prefix);
    }
}

