/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.digital.impl;

import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.impl.IOAddressConfigBase;
import com.pi4j.util.StringUtil;
import java.util.Map;

public class DefaultDigitalOutputConfig
extends IOAddressConfigBase<DigitalOutputConfig>
implements DigitalOutputConfig {
    protected DigitalState shutdownState = null;
    protected DigitalState initialState = null;
    protected DigitalState onState = DigitalState.HIGH;

    private DefaultDigitalOutputConfig() {
    }

    protected DefaultDigitalOutputConfig(Map<String, String> properties) {
        super(properties);
        this.id = StringUtil.setIfNullOrEmpty(this.id, "DOUT-" + this.address, true);
        this.name = StringUtil.setIfNullOrEmpty(this.name, "DOUT-" + this.address, true);
        this.description = StringUtil.setIfNullOrEmpty(this.description, "DOUT-" + this.address, true);
        if (properties.containsKey("initial")) {
            this.initialState = DigitalState.parse(properties.get("initial"));
        }
        if (properties.containsKey("shutdown")) {
            this.shutdownState = DigitalState.parse(properties.get("shutdown"));
        }
        if (properties.containsKey("onstate")) {
            this.onState = DigitalState.parse(properties.get("onstate"));
        }
    }

    @Override
    public DigitalState shutdownState() {
        return this.shutdownState;
    }

    @Override
    public DefaultDigitalOutputConfig shutdownState(DigitalState state) {
        this.shutdownState = state;
        return this;
    }

    @Override
    public DigitalState initialState() {
        return this.initialState;
    }

    @Override
    public DigitalState onState() {
        return this.onState;
    }
}

