/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.spi;

import com.pi4j.io.spi.Spi;

public enum SpiChipSelect {
    CS_0(0),
    CS_1(1),
    CS_2(2);

    private final int address;

    private SpiChipSelect(int address) {
        this.address = address;
    }

    public int getChipSelect() {
        return this.address;
    }

    public static SpiChipSelect getByNumber(short address) {
        return SpiChipSelect.getByNumber((int)address);
    }

    public static SpiChipSelect getByNumber(int address) {
        for (SpiChipSelect item : SpiChipSelect.values()) {
            if (item.getChipSelect() != address) continue;
            return item;
        }
        return null;
    }

    public static SpiChipSelect parse(String bus) {
        if (bus.equalsIgnoreCase("0")) {
            return CS_0;
        }
        if (bus.equalsIgnoreCase("1")) {
            return CS_1;
        }
        if (bus.equalsIgnoreCase("2")) {
            return CS_2;
        }
        return Spi.DEFAULT_CHIP_SELECT;
    }
}

