/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorPool {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorPool.class);
    private final Map<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();
    private final Map<String, ScheduledExecutorService> scheduledExecutors = new ConcurrentHashMap<String, ScheduledExecutorService>();

    public ExecutorService getExecutor(String poolName) {
        if (poolName == null || poolName.isEmpty()) {
            throw new IllegalStateException("poolName must be set!");
        }
        return this.executors.computeIfAbsent(poolName, p -> Executors.newCachedThreadPool(new NamedThreadPoolFactory((String)p)));
    }

    public ExecutorService getSingleThreadExecutor(String poolName) {
        if (poolName == null || poolName.isEmpty()) {
            throw new IllegalStateException("poolName must be set!");
        }
        return this.executors.computeIfAbsent(poolName, p -> Executors.newSingleThreadExecutor(new NamedThreadPoolFactory((String)p)));
    }

    public ScheduledExecutorService getScheduledExecutor(String poolName) {
        if (poolName == null || poolName.isEmpty()) {
            throw new IllegalStateException("poolName must be set!");
        }
        return this.scheduledExecutors.computeIfAbsent(poolName, p -> Executors.newScheduledThreadPool(4, new NamedThreadPoolFactory((String)p)));
    }

    public void destroy() {
        this.executors.forEach(this::shutdownExecutor);
        this.scheduledExecutors.forEach(this::shutdownExecutor);
    }

    private void shutdownExecutor(String name, ExecutorService executor) {
        logger.info("Shutting down executor pool {}", (Object)name);
        try {
            List<Runnable> tasks = executor.shutdownNow();
            if (!tasks.isEmpty()) {
                logger.warn("The following {} tasks were never started for executor {} :", (Object)tasks.size(), (Object)name);
                for (Runnable runnable : tasks) {
                    logger.warn("  " + String.valueOf(runnable));
                }
            }
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                logger.error("Executor {} did not stop after 5s!", (Object)name);
            }
        }
        catch (InterruptedException e) {
            logger.error("Was interrupted while shutting down tasks");
        }
    }

    private static class NamedThreadPoolFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String poolName;

        public NamedThreadPoolFactory(String poolName) {
            this.group = Thread.currentThread().getThreadGroup();
            this.poolName = poolName + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.poolName + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

