/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.io.OnOff;
import com.pi4j.io.Output;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.gpio.digital.Digital;
import com.pi4j.io.gpio.digital.DigitalOutputBuilder;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public interface DigitalOutput
extends Digital<DigitalOutput, DigitalOutputConfig, DigitalOutputProvider>,
Output,
OnOff<DigitalOutput> {
    public static DigitalOutputConfigBuilder newConfigBuilder(Context context) {
        return DigitalOutputConfigBuilder.newInstance(context);
    }

    public static DigitalOutputBuilder newBuilder(Context context) {
        return DigitalOutputBuilder.newInstance(context);
    }

    public DigitalOutput state(DigitalState var1) throws IOException;

    public DigitalOutput pulse(int var1, TimeUnit var2, DigitalState var3, Callable<Void> var4) throws IOException;

    public Future<?> pulseAsync(int var1, TimeUnit var2, DigitalState var3, Callable<Void> var4);

    public DigitalOutput blink(int var1, int var2, TimeUnit var3, DigitalState var4, Callable<Void> var5);

    public Future<?> blinkAsync(int var1, int var2, TimeUnit var3, DigitalState var4, Callable<Void> var5);

    default public DigitalOutput setState(boolean state) throws IOException {
        return this.state(DigitalState.getState(state));
    }

    default public DigitalOutput setState(byte state) throws IOException {
        return this.state(DigitalState.getState(state));
    }

    default public DigitalOutput setState(short state) throws IOException {
        return this.state(DigitalState.getState(state));
    }

    default public DigitalOutput setState(int state) throws IOException {
        return this.state(DigitalState.getState(state));
    }

    default public DigitalOutput setState(long state) throws IOException {
        return this.state(DigitalState.getState(state));
    }

    default public DigitalOutput setState(float state) throws IOException {
        return this.state(DigitalState.getState(Float.valueOf(state)));
    }

    default public DigitalOutput setState(double state) throws IOException {
        return this.state(DigitalState.getState(state));
    }

    default public DigitalOutput high() throws IOException {
        return this.state(DigitalState.HIGH);
    }

    default public DigitalOutput low() throws IOException {
        return this.state(DigitalState.LOW);
    }

    @Override
    default public DigitalOutput toggle() throws IOException {
        return this.state(DigitalState.getInverseState(this.state()));
    }

    default public DigitalOutput pulseHigh(int interval, TimeUnit unit) throws IOException {
        return this.pulse(interval, unit, DigitalState.HIGH);
    }

    default public DigitalOutput pulseLow(int interval, TimeUnit unit) throws IOException {
        return this.pulse(interval, unit, DigitalState.LOW);
    }

    default public Future<?> pulseHighAsync(int interval, TimeUnit unit, Callable<Void> callback) {
        return this.pulseAsync(interval, unit, DigitalState.HIGH, callback);
    }

    default public Future<?> pulseLowAsync(int interval, TimeUnit unit, Callable<Void> callback) {
        return this.pulseAsync(interval, unit, DigitalState.LOW, callback);
    }

    default public DigitalOutput pulse(int interval, TimeUnit unit) throws IOException {
        return this.pulse(interval, unit, DigitalState.HIGH);
    }

    default public DigitalOutput pulse(int interval, TimeUnit unit, DigitalState state) throws IOException {
        return this.pulse(interval, unit, state, null);
    }

    default public Future<?> pulseAsync(int interval, TimeUnit unit) {
        return this.pulseAsync(interval, unit, DigitalState.HIGH);
    }

    default public Future<?> pulseAsync(int interval, TimeUnit unit, DigitalState state) {
        return this.pulseAsync(interval, unit, state, null);
    }

    default public DigitalOutput blink(int interval, TimeUnit unit) {
        return this.blink(interval, interval, unit);
    }

    default public DigitalOutput blink(int delay, int duration, TimeUnit unit) {
        return this.blink(delay, duration, unit, DigitalState.HIGH);
    }

    default public DigitalOutput blink(int delay, int duration, TimeUnit unit, DigitalState state) {
        return this.blink(delay, duration, unit, state, null);
    }

    default public Future<?> blinkAsync(int interval, TimeUnit unit) {
        return this.blinkAsync(interval, interval, unit, DigitalState.HIGH);
    }

    default public Future<?> blinkAsync(int delay, int duration, TimeUnit unit) {
        return this.blinkAsync(delay, duration, unit, DigitalState.HIGH);
    }

    default public Future<?> blinkAsync(int delay, int duration, TimeUnit unit, DigitalState state) {
        return this.blinkAsync(delay, duration, unit, state, null);
    }
}

