/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c;

import com.pi4j.context.Context;
import com.pi4j.io.IO;
import com.pi4j.io.IODataReader;
import com.pi4j.io.IODataWriter;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.io.i2c.I2CRegister;
import com.pi4j.io.i2c.I2CRegisterDataReaderWriter;
import java.util.concurrent.Callable;

public interface I2C
extends IO<I2C, I2CConfig, I2CProvider>,
IODataWriter,
IODataReader,
I2CRegisterDataReaderWriter,
AutoCloseable {
    @Override
    public void close();

    public static I2CConfigBuilder newConfigBuilder(Context context) {
        return I2CConfigBuilder.newInstance(context);
    }

    default public int device() {
        return ((I2CConfig)this.config()).device();
    }

    default public int bus() {
        return ((I2CConfig)this.config()).bus();
    }

    public boolean isOpen();

    default public int getBus() {
        return this.bus();
    }

    default public int getDevice() {
        return this.device();
    }

    default public int writeRead(byte[] writeBuffer, byte[] readBuffer) {
        return this.writeRead(writeBuffer, writeBuffer.length, 0, readBuffer, readBuffer.length, 0);
    }

    default public int writeRead(byte[] writeBuffer, int writeSize, int writeOffset, byte[] readBuffer, int readSize, int readOffset) {
        if (writeOffset < 0) {
            throw new IndexOutOfBoundsException("Write offset cannot be negative!");
        }
        if (writeOffset + writeSize > writeBuffer.length) {
            throw new IndexOutOfBoundsException(String.format("Write operation out of bounds. Write buffer length is %d. Yet write offset + size is=%d", writeBuffer.length, writeOffset + writeSize));
        }
        if (readOffset < 0) {
            throw new IndexOutOfBoundsException("Read offset cannot be negative!");
        }
        if (readOffset + readSize > readBuffer.length) {
            throw new IndexOutOfBoundsException(String.format("Read operation out of bounds. Read buffer length is %d. Yet read offset + size is=%d", readBuffer.length, readOffset + readSize));
        }
        return this.execute(() -> {
            int written = this.write(writeBuffer, writeOffset, writeSize);
            if (written != writeSize) {
                throw new IllegalStateException("Expected to write " + writeSize + " bytes but only wrote " + written + " bytes");
            }
            return this.read(readBuffer, readOffset, readSize);
        });
    }

    public I2CRegister getRegister(int var1);

    default public I2CRegister register(int address) {
        return this.getRegister(address);
    }

    public <T> T execute(Callable<T> var1);
}

