/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.datareader;

import com.pi4j.boardinfo.util.command.CommandResult;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardCodeReader {
    private static final Logger logger = LoggerFactory.getLogger(BoardCodeReader.class);
    private static String modelFilePath = "/proc/device-tree/model";

    public static void setModelFilePath(String path) {
        modelFilePath = path;
    }

    public static CommandResult getBoardCode() {
        String outputMessage = "";
        Object errorMessage = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(modelFilePath));){
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
            outputMessage = content.toString().trim();
        }
        catch (IOException ex) {
            errorMessage = "IOException: " + ex.getMessage();
            logger.error("Failed to read the board model from '{}': {}", (Object)modelFilePath, errorMessage);
        }
        if (!((String)errorMessage).isEmpty()) {
            return CommandResult.failure((String)errorMessage);
        }
        return CommandResult.success(outputMessage);
    }
}

