/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.datareader;

import com.pi4j.boardinfo.util.command.CommandResult;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemInfoReader {
    private static final Logger logger = LoggerFactory.getLogger(MemInfoReader.class);
    private static String memInfoFilePath = "/proc/meminfo";

    public static void setMemInfoFilePath(String path) {
        memInfoFilePath = path;
    }

    public static CommandResult getMemTotal() {
        Object errorMessage = "";
        String memTotalLine = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(memInfoFilePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("MemTotal:")) continue;
                memTotalLine = line.trim();
                break;
            }
        }
        catch (IOException ex) {
            errorMessage = "IOException: " + ex.getMessage();
            logger.error("Failed to read memory information from '{}': {}", (Object)memInfoFilePath, errorMessage);
        }
        if (!((String)errorMessage).isEmpty()) {
            return CommandResult.failure((String)errorMessage);
        }
        if (memTotalLine.isEmpty()) {
            return CommandResult.failure("MemTotal entry not found in memory information file.");
        }
        return CommandResult.success(memTotalLine);
    }
}

