/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.model;

public class JvmMemory {
    private static final double MB = 1048576.0;
    private final long total;
    private final long free;
    private final long used;
    private final long max;

    public JvmMemory(Runtime runtime) {
        this.total = runtime.totalMemory();
        this.free = runtime.freeMemory();
        this.used = this.total - this.free;
        this.max = runtime.maxMemory();
    }

    public long getTotal() {
        return this.total;
    }

    public long getFree() {
        return this.free;
    }

    public long getUsed() {
        return this.used;
    }

    public long getMax() {
        return this.max;
    }

    public double getTotalInMb() {
        return (double)this.total / 1048576.0;
    }

    public double getFreeInMb() {
        return (double)this.free / 1048576.0;
    }

    public double getUsedInMb() {
        return (double)this.used / 1048576.0;
    }

    public double getMaxInMb() {
        return (double)this.max / 1048576.0;
    }
}

