/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.model;

import java.util.ArrayList;
import java.util.List;

public enum ThrottledState {
    UNDERVOLTAGE_DETECTED(1, "Undervoltage detected"),
    ARM_FREQUENCY_CAPPED(2, "ARM frequency capped"),
    CURRENTLY_THROTTLED(4, "Currently throttled"),
    SOFT_TEMPERATURE_LIMIT_ACTIVE(8, "Soft temperature limit active"),
    UNDERVOLTAGE_HAS_OCCURED(65536, "Undervoltage has occurred"),
    ARM_FREQUENCY_CAPPING_HAS_OCCURED(131072, "ARM frequency capping has occurred"),
    THROTTLING_HAS_OCCURED(262144, "Throttling has occurred"),
    SOFT_TEMPERATURE_LIMIT_HAS_OCCURED(524288, "Soft temperature limit has occurred");

    private final int value;
    private final String description;

    private ThrottledState(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<ThrottledState> decode(int rawState) {
        ArrayList<ThrottledState> activeStates = new ArrayList<ThrottledState>();
        for (ThrottledState state : ThrottledState.values()) {
            if ((rawState & state.getValue()) == 0) continue;
            activeStates.add(state);
        }
        return activeStates;
    }

    public static String getActiveStatesDescription(int rawState) {
        List<ThrottledState> activeStates = ThrottledState.decode(rawState);
        StringBuilder description = new StringBuilder();
        for (ThrottledState state : activeStates) {
            if (description.length() > 0) {
                description.append(", ");
            }
            description.append(state.getDescription());
        }
        return description.length() > 0 ? description.toString() : "No active throttled states";
    }
}

