/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.util.command;

import com.pi4j.boardinfo.util.command.CommandResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CommandExecutor.class);
    private static final int COMMAND_TIMEOUT_SECONDS = 30;

    public static CommandResult execute(String command) {
        boolean finished = false;
        String outputMessage = "";
        Object errorMessage = "";
        ProcessBuilder builder = new ProcessBuilder(command.split(" "));
        try {
            Process process = builder.start();
            outputMessage = CommandExecutor.readStream(process.getInputStream());
            errorMessage = CommandExecutor.readStream(process.getErrorStream());
            finished = process.waitFor(30L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                errorMessage = "Process timeout after 30 seconds.";
            }
        }
        catch (IOException ex) {
            errorMessage = "IOException while executing command: " + ex.getMessage();
            logger.error("IOException during command execution '{}': {}", new Object[]{command, ex.getMessage(), ex});
        }
        catch (InterruptedException ex) {
            errorMessage = "InterruptedException during command execution: " + ex.getMessage();
            Thread.currentThread().interrupt();
            logger.error("InterruptedException during command execution '{}': {}", new Object[]{command, ex.getMessage(), ex});
        }
        if (!finished || !((String)errorMessage).isEmpty()) {
            logger.error("Failed to execute command '{}': {}", (Object)command, errorMessage);
            return CommandResult.failure((String)errorMessage);
        }
        return CommandResult.success(outputMessage);
    }

    private static String readStream(InputStream inputStream) {
        StringBuilder content = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException ex) {
            content.append("ERROR: ").append(ex.getMessage());
            logger.error("Error reading stream: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return content.toString().trim();
    }
}

