/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.boardinfo.util.command;

import java.util.Objects;
import java.util.Optional;

public class CommandResult {
    private final boolean success;
    private final String outputMessage;
    private final String errorMessage;

    private CommandResult(boolean success, String outputMessage, String errorMessage) {
        this.success = success;
        this.outputMessage = Optional.ofNullable(outputMessage).orElse("");
        this.errorMessage = Optional.ofNullable(errorMessage).orElse("");
    }

    public static CommandResult success(String outputMessage) {
        return new CommandResult(true, outputMessage, null);
    }

    public static CommandResult failure(String errorMessage) {
        return new CommandResult(false, null, errorMessage);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getOutputMessage() {
        return this.outputMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return String.format("CommandResult{success=%b, outputMessage='%s', errorMessage='%s'}", this.success, this.outputMessage, this.errorMessage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResult that = (CommandResult)o;
        return this.success == that.success && Objects.equals(this.outputMessage, that.outputMessage) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.outputMessage, this.errorMessage);
    }
}

